/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.internal;

import de.prob.cli.CliException;
import de.prob.core.LanguageDependendAnimationPart;
import de.prob.core.ProblemHandler;
import de.prob.core.command.CommandException;
import de.prob.core.command.ComposedCommand;
import de.prob.core.command.GetErrorsCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.HistoryItem;
import de.prob.core.domainobjects.MachineDescription;
import de.prob.core.domainobjects.State;
import de.prob.core.internal.ServerConnection;
import de.prob.core.sablecc.node.ACallBackResult;
import de.prob.core.sablecc.node.AProgressResult;
import de.prob.core.sablecc.node.AYesResult;
import de.prob.core.sablecc.node.PResult;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.parser.PrologTermGenerator;
import de.prob.parser.ResultParserException;
import de.prob.parser.SimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.PrologTermStringOutput;
import de.prob.prolog.term.PrologTerm;
import java.io.File;
import java.util.List;
import java.util.Map;

public class AnimatorImpl {
    private final History history = new History();
    private ServerConnection connector;
    private MachineDescription description;
    private final File file;
    private LanguageDependendAnimationPart langdep;

    public AnimatorImpl(ServerConnection serverConnection, File file) {
        this.file = file;
        this.setConnector(serverConnection);
    }

    public synchronized void shutdownImplementation() {
        if (this.connector != null) {
            this.connector.shutdown();
        }
        this.connector = null;
        this.history.reset();
        this.description = null;
    }

    private void checkConnector(String command) throws CliException {
        if (this.connector == null) {
            String message = "The connection to the ProB instance has not been established. Tried to execute " + command;
            ProblemHandler.raiseCliException(message);
        }
    }

    public State getCurrentStateImpl() {
        HistoryItem item = this.history.getCurrent();
        return item == null ? null : item.getState();
    }

    public History getHistoryImpl() {
        return this.history;
    }

    private synchronized void setConnector(ServerConnection serverConnection) {
        this.connector = serverConnection;
        try {
            this.connector.startup(this.file);
        }
        catch (CliException e) {
            e.notifyUserOnce();
            this.connector = null;
        }
    }

    public boolean isRunning() {
        return true;
    }

    public synchronized void setMachineDescription(MachineDescription machineDescription) {
        this.description = machineDescription;
    }

    public synchronized MachineDescription getMachineDescription() {
        return this.description;
    }

    public boolean isMachineLoaded() {
        return this.description != null;
    }

    public void execute(IComposableCommand command) throws ProBException {
        this.checkConnector(command.getClass().getName());
        GetErrorsCommand getErrors = new GetErrorsCommand();
        ComposedCommand cmds = new ComposedCommand(command, getErrors);
        SimplifiedROMap<String, PrologTerm> bindings = null;
        List<String> errors = null;
        try {
            try {
                bindings = this.sendCommand(cmds);
                cmds.processResult((ISimplifiedROMap<String, PrologTerm>)bindings);
                errors = getErrors.getErrors();
            }
            catch (RuntimeException e) {
                Logger.notifyUser(e.getLocalizedMessage(), e);
                if (errors == null) {
                    if (bindings == null) {
                        bindings = this.sendCommand(getErrors);
                        getErrors.processResult((ISimplifiedROMap<String, PrologTerm>)bindings);
                    } else {
                        cmds.reprocessResult(getErrors, (ISimplifiedROMap<String, PrologTerm>)bindings);
                    }
                    errors = getErrors.getErrors();
                }
                if (errors != null && !errors.isEmpty()) {
                    ProblemHandler.raisePrologException(errors, getErrors.onlyWarningsOccurred());
                }
            }
        }
        finally {
            if (errors == null) {
                if (bindings == null) {
                    bindings = this.sendCommand(getErrors);
                    getErrors.processResult((ISimplifiedROMap<String, PrologTerm>)bindings);
                } else {
                    cmds.reprocessResult(getErrors, (ISimplifiedROMap<String, PrologTerm>)bindings);
                }
                errors = getErrors.getErrors();
            }
            if (errors != null && !errors.isEmpty()) {
                ProblemHandler.raisePrologException(errors, getErrors.onlyWarningsOccurred());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimplifiedROMap<String, PrologTerm> sendCommand(IComposableCommand command) throws ProBException, CommandException {
        Map bindings;
        PrologTermStringOutput pto = new PrologTermStringOutput();
        command.writeCommand((IPrologTermOutput)pto);
        String query = pto.fullstop().toString();
        try {
            PResult topnode;
            AnimatorImpl animatorImpl = this;
            synchronized (animatorImpl) {
                topnode = this.connector.sendCommand(query);
            }
            assert (topnode != null);
            assert (!(topnode instanceof AProgressResult));
            assert (!(topnode instanceof ACallBackResult));
            if (!(topnode instanceof AYesResult)) {
                Object queryForMessage = query;
                if (((String)queryForMessage).length() > 400) {
                    queryForMessage = ((String)queryForMessage).substring(0, 400) + "...";
                }
                throw new ResultParserException("Prolog query failed - received " + topnode.getClass().getSimpleName() + " in response to query: " + (String)queryForMessage, null);
            }
            bindings = BindingGenerator.createBinding((PrologTerm)PrologTermGenerator.toPrologTerm((PResult)topnode));
        }
        catch (ResultParserException e) {
            Logger.notifyUser(e.getMessage(), e);
            throw new CommandException(e.getMessage(), e);
        }
        return new SimplifiedROMap(bindings);
    }

    public LanguageDependendAnimationPart getLangdep() {
        return this.langdep;
    }

    public void setLangdep(LanguageDependendAnimationPart langdep) {
        this.langdep = langdep;
    }

    public void sendUserInterruptSignal() {
        if (this.connector != null) {
            this.connector.sendUserInterruptSignal();
        }
    }
}

