/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExamplePredicate;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleUnaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleUntil;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CounterExampleFinally
extends CounterExampleUnaryOperator {
    public CounterExampleFinally(CounterExample counterExample, CounterExampleProposition argument) {
        super("F", "Finally", counterExample, argument);
        this.checkByUntil(counterExample, argument);
    }

    private void checkByUntil(CounterExample counterExample, CounterExampleProposition argument) {
        CounterExampleValueType[] firstValues = new CounterExampleValueType[argument.getValues().size()];
        Arrays.fill((Object[])firstValues, (Object)CounterExampleValueType.TRUE);
        CounterExamplePredicate first = new CounterExamplePredicate("", counterExample, Arrays.asList(firstValues));
        this.addCheck(new CounterExampleUntil(counterExample, first, argument));
    }

    @Override
    protected CounterExampleValueType calculate(int position) {
        int index;
        CounterExampleValueType result = CounterExampleValueType.UNKNOWN;
        List<CounterExampleValueType> checkedValues = new ArrayList<CounterExampleValueType>(this.argument.getValues());
        if (this.pathType == LtlCheckingCommand.PathType.INFINITE && position > this.loopEntry) {
            checkedValues.addAll(checkedValues.subList(this.loopEntry, position));
        }
        if ((index = (checkedValues = checkedValues.subList(position, checkedValues.size())).indexOf((Object)CounterExampleValueType.TRUE)) != -1) {
            result = CounterExampleValueType.TRUE;
        } else if (this.pathType != LtlCheckingCommand.PathType.REDUCED) {
            result = CounterExampleValueType.FALSE;
        }
        this.fillHighlightedPositions(position, index, checkedValues.size(), false);
        return result;
    }
}

