/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleBinaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;

public final class CounterExampleDisjunction
extends CounterExampleBinaryOperator {
    public CounterExampleDisjunction(CounterExample counterExample, CounterExampleProposition firstArgument, CounterExampleProposition secondArgument) {
        super("or", "Disjunction", counterExample, firstArgument, secondArgument);
    }

    @Override
    protected CounterExampleValueType calculate(int position) {
        CounterExampleValueType firstValue = this.getFirstArgument().getValues().get(position);
        CounterExampleValueType secondValue = this.getSecondArgument().getValues().get(position);
        int firstCheckedSize = 1;
        int secondCheckedSize = 1;
        if (firstValue == CounterExampleValueType.TRUE) {
            secondCheckedSize = 0;
        } else if (secondValue == CounterExampleValueType.TRUE) {
            firstCheckedSize = 0;
        }
        this.fillHighlightedPositions(position, -1, -1, firstCheckedSize, secondCheckedSize, false);
        return CounterExampleDisjunction.calculateOr(firstValue, secondValue);
    }

    public static CounterExampleValueType calculateOr(CounterExampleValueType firstValue, CounterExampleValueType secondValue) {
        CounterExampleValueType result = CounterExampleValueType.FALSE;
        if (firstValue == CounterExampleValueType.TRUE || secondValue == CounterExampleValueType.TRUE) {
            result = CounterExampleValueType.TRUE;
        } else if (firstValue == CounterExampleValueType.UNKNOWN || secondValue == CounterExampleValueType.UNKNOWN) {
            result = CounterExampleValueType.UNKNOWN;
        }
        return result;
    }
}

