/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects;

import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.StateError;
import de.prob.core.domainobjects.Variable;
import de.prob.logging.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class State {
    private static final String ERROR_MSG = "Enabled Operations was null, this is most likely an error in the core.";
    private final String id;
    private final boolean initialized;
    private final boolean invariantViolated;
    private final List<Operation> enabledOperations;
    private final boolean timeoutOccured;
    private final boolean maxOperationReached;
    private final Collection<StateError> stateErrors;
    private final Map<String, Variable> stateValues;
    private final Set<String> timeout;

    public State(String stateId, boolean initialised, boolean invariantKo, boolean timeoutOccured, boolean maxOperationReached, Collection<Variable> stateValues, List<Operation> enabledOperations, Collection<StateError> stateErrors, Set<String> timeoutedOperations) {
        this.id = stateId;
        this.initialized = initialised;
        this.invariantViolated = invariantKo;
        this.timeoutOccured = timeoutOccured;
        this.maxOperationReached = maxOperationReached;
        this.stateErrors = stateErrors;
        this.timeout = timeoutedOperations;
        HashMap<String, Variable> vars = new HashMap<String, Variable>(stateValues.size());
        for (Variable v : stateValues) {
            String identifier = v.getIdentifier();
            if (vars.containsKey(identifier)) {
                Logger.notifyUser("ProB returned a variable twice.");
                continue;
            }
            vars.put(identifier, v);
        }
        this.stateValues = Collections.unmodifiableMap(vars);
        Logger.assertProB(ERROR_MSG, enabledOperations != null);
        this.enabledOperations = Collections.unmodifiableList(enabledOperations);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isInvariantViolated() {
        return this.invariantViolated;
    }

    public boolean isInvariantPreserved() {
        return !this.invariantViolated;
    }

    public boolean isMaxOperationReached() {
        return this.maxOperationReached;
    }

    public boolean isTimeoutOccured() {
        return this.timeoutOccured;
    }

    public String getId() {
        return this.id;
    }

    public final List<Operation> getEnabledOperations() {
        return this.enabledOperations;
    }

    public Map<String, Variable> getValues() {
        return this.stateValues;
    }

    public boolean variableHasValue(String variable) {
        return this.stateValues.containsKey(variable);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.id);
        if (this.isInvariantViolated()) {
            result.append(" (Invariant violated)");
        }
        result.append(": Var[");
        result.append(this.stateValues.values());
        result.append("]");
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof State) {
            return this.id.equals(((State)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Collection<StateError> getStateBasedErrors() {
        return this.stateErrors;
    }

    public boolean hasStateBasedErrors() {
        return !this.stateErrors.isEmpty();
    }

    public boolean isTimeoutOp(String opName) {
        return this.timeout.contains(opName);
    }
}

