/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects;

import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import org.eclipse.core.runtime.Assert;

public final class HistoryItem {
    private final State state;
    private final Operation operation;

    public HistoryItem(State state, Operation operation) {
        Assert.isNotNull((Object)state);
        this.state = state;
        this.operation = operation;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("(");
        result.append(this.state.getId());
        result.append(")");
        if (this.operation != null) {
            result.append(" -");
            result.append(this.operation.getName());
            result.append("-> (");
            result.append(this.operation.getDestination());
            result.append(")");
        }
        return result.toString();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public State getState() {
        return this.state;
    }

    public String getStateId() {
        return this.state.getId();
    }
}

