/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects;

import de.prob.core.Animator;
import de.prob.core.command.EvaluationGetValuesCommand;
import de.prob.core.domainobjects.EvaluationElement;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EvaluationStateElement {
    public static final EvaluationStateElement[] EMPTY_EVALUATION_STATE_ELEMENT_ARRAY = new EvaluationStateElement[0];
    private final EvaluationElement element;
    private final State state;
    private final EvaluationGetValuesCommand.EvaluationResult result;
    private List<EvaluationStateElement> children;

    public EvaluationStateElement(EvaluationElement element, State state, EvaluationGetValuesCommand.EvaluationResult result) {
        this.element = element;
        this.state = state;
        this.result = result;
    }

    public EvaluationElement getElement() {
        return this.element;
    }

    public State getState() {
        return this.state;
    }

    public List<EvaluationStateElement> getChildren() throws ProBException {
        this.checkChildren();
        return this.children;
    }

    public EvaluationGetValuesCommand.EvaluationResult getResult() {
        return this.result;
    }

    private void checkChildren() throws ProBException {
        if (this.children == null) {
            EvaluationElement[] staticChildren = this.element.getChildren();
            EvaluationGetValuesCommand cmd = new EvaluationGetValuesCommand(this.state.getId(), Arrays.asList(staticChildren));
            Animator.getAnimator().execute(cmd);
            Map<EvaluationElement, EvaluationGetValuesCommand.EvaluationResult> values = cmd.getResult();
            this.children = new ArrayList<EvaluationStateElement>(staticChildren.length);
            EvaluationElement[] evaluationElementArray = staticChildren;
            int n = staticChildren.length;
            int n2 = 0;
            while (n2 < n) {
                EvaluationElement staticChild = evaluationElementArray[n2];
                EvaluationGetValuesCommand.EvaluationResult value = values.get(staticChild);
                this.children.add(new EvaluationStateElement(staticChild, this.state, value));
                ++n2;
            }
            this.children = Collections.unmodifiableList(this.children);
        }
    }

    public int hashCode() {
        return 19 * (13 + this.element.hashCode()) + this.state.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EvaluationStateElement other = (EvaluationStateElement)obj;
        return this.element.equals(other.element) && this.state.equals(other.state);
    }

    public String getText() {
        return this.result == null ? null : this.result.getText();
    }
}

