/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Variable;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.parser.ResultParserException;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.List;

public final class GetStateValuesCommand
implements IComposableCommand {
    private final String stateId;
    private List<Variable> result;

    public GetStateValuesCommand(String stateID) {
        this.stateId = stateID;
    }

    public List<Variable> getResult() {
        return this.result;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        ListPrologTerm list;
        ArrayList<Variable> variables = new ArrayList<Variable>();
        try {
            list = BindingGenerator.getList(bindings, (String)"Bindings");
        }
        catch (ResultParserException e) {
            CommandException commandException = new CommandException(e.getLocalizedMessage(), e);
            commandException.notifyUserOnce();
            throw commandException;
        }
        for (PrologTerm term : list) {
            CompoundPrologTerm compoundTerm;
            try {
                compoundTerm = BindingGenerator.getCompoundTerm((PrologTerm)term, (String)"binding", (int)3);
            }
            catch (ResultParserException e) {
                CommandException commandException = new CommandException(e.getLocalizedMessage(), e);
                commandException.notifyUserOnce();
                throw commandException;
            }
            variables.add(new Variable(compoundTerm));
        }
        this.result = variables;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("getStateValues").printAtomOrNumber(this.stateId).printVariable("Bindings").closeTerm();
    }
}

