/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.GetCurrentStateIdCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public final class GetFullTraceCommand
implements IComposableCommand {
    private static final String IDS_VARIABLE = "IDs";
    private static final String ACTIONS_VARIABLE = "Actions";
    private TraceResult trace;

    private GetFullTraceCommand() {
    }

    public static TraceResult getTrace(Animator a) throws ProBException {
        GetFullTraceCommand cmd = new GetFullTraceCommand();
        a.execute(cmd);
        return cmd.getTrace();
    }

    private TraceResult getTrace() {
        return this.trace;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        List operations = PrologTerm.atomicStrings((Iterable)((ListPrologTerm)bindings.get((Object)ACTIONS_VARIABLE)));
        List<String> states = GetCurrentStateIdCommand.getStateIDs((Collection<PrologTerm>)((ListPrologTerm)bindings.get((Object)IDS_VARIABLE)));
        this.trace = new TraceResult(operations, states);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("find_shortest_trace_to_current_state2");
        pto.printVariable(ACTIONS_VARIABLE);
        pto.printVariable(IDS_VARIABLE).closeTerm();
    }

    public static class TraceResult {
        private final List<String> operations;
        private final List<String> states;

        public TraceResult(List<String> operations, List<String> states) {
            Assert.isTrue((operations.size() == states.size() ? 1 : 0) != 0);
            this.operations = Collections.unmodifiableList(operations);
            this.states = Collections.unmodifiableList(states);
        }

        public List<String> getOperations() {
            return this.operations;
        }

        public List<String> getStates() {
            return this.states;
        }
    }
}

