/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.LimitedLogger;
import de.prob.core.command.CommandException;
import de.prob.core.command.ComposedCommand;
import de.prob.core.command.ExploreStateCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.core.command.SetStateCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;

public final class ExecuteOperationCommand
implements IComposableCommand {
    private final Operation operation;
    private final boolean fireCurrentStateChanged;
    private final ExploreStateCommand exloreStateCmd;
    private final SetStateCommand setStateCmd;
    private final IComposableCommand cmds;

    private ExecuteOperationCommand(Operation operation) {
        this(operation, false);
    }

    private ExecuteOperationCommand(Operation operation, boolean silent) {
        this.operation = operation;
        this.fireCurrentStateChanged = !silent;
        String stateId = operation.getDestination();
        this.exloreStateCmd = new ExploreStateCommand(stateId);
        this.setStateCmd = new SetStateCommand(stateId);
        this.cmds = new ComposedCommand(this.exloreStateCmd, this.setStateCmd);
    }

    public static void executeOperation(Animator a, Operation op) throws ProBException {
        ExecuteOperationCommand executeOperationCommand = new ExecuteOperationCommand(op);
        a.execute(executeOperationCommand);
    }

    public static void executeOperation(Animator a, Operation op, boolean silent) throws ProBException {
        ExecuteOperationCommand executeOperationCommand = new ExecuteOperationCommand(op, silent);
        a.execute(executeOperationCommand);
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        this.cmds.processResult(bindings);
        Animator animator = Animator.getAnimator();
        State state = this.exloreStateCmd.getState();
        animator.getHistory().add(state, this.operation);
        if (this.fireCurrentStateChanged) {
            animator.announceCurrentStateChanged(state, this.operation);
        }
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) throws CommandException {
        LimitedLogger.getLogger().log("execute operation", this.operation.getName(), null);
        this.cmds.writeCommand(pto);
    }
}

