/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.LanguageDependendAnimationPart;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.EvaluationElement;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.parserbase.ProBParseException;
import de.prob.parserbase.ProBParserBase;
import de.prob.parserbase.ProBParserBaseAdapter;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;

public class EvaluationInsertFormulaCommand
implements IComposableCommand {
    private static final String VARNAME_ID = "ID";
    private final PrologTerm rawExpression;
    private PrologTerm id;

    public static EvaluationElement insertFormula(PrologTerm formula) throws ProBException {
        EvaluationInsertFormulaCommand cmd = new EvaluationInsertFormulaCommand(formula);
        Animator animator = Animator.getAnimator();
        animator.execute(cmd);
        return new EvaluationElement(animator, cmd.getId(), null);
    }

    public static EvaluationElement insertPredicate(String formula) throws ProBException, UnsupportedOperationException, ProBParseException {
        return EvaluationInsertFormulaCommand.insertFormula(EvaluationInsertFormulaCommand.getParser().parsePredicate(formula, false));
    }

    public static EvaluationElement insertExpression(String formula) throws ProBException, UnsupportedOperationException, ProBParseException {
        return EvaluationInsertFormulaCommand.insertFormula(EvaluationInsertFormulaCommand.getParser().parseExpression(formula, false));
    }

    public static EvaluationElement insertFormula(Animator animator, FormulaType type, String formula) throws ProBException, UnsupportedOperationException, ProBParseException {
        PrologTerm parsed;
        ProBParserBaseAdapter parser = EvaluationInsertFormulaCommand.getParser(animator);
        switch (type) {
            case EXPRESSION: {
                parsed = parser.parseExpression(formula, false);
                break;
            }
            case PREDICATE: {
                parsed = parser.parsePredicate(formula, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported formula type: " + String.valueOf((Object)type));
            }
        }
        return EvaluationInsertFormulaCommand.insertFormula(parsed);
    }

    private static ProBParserBaseAdapter getParser() {
        return EvaluationInsertFormulaCommand.getParser(Animator.getAnimator());
    }

    private static ProBParserBaseAdapter getParser(Animator animator) {
        LanguageDependendAnimationPart ldp = animator.getLanguageDependendPart();
        if (ldp == null) {
            throw new UnsupportedOperationException("The current formalism does not allow parsing of formulas");
        }
        return new ProBParserBaseAdapter((ProBParserBase)ldp);
    }

    public EvaluationInsertFormulaCommand(PrologTerm rawExpression) {
        this.rawExpression = rawExpression;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        this.id = (PrologTerm)bindings.get((Object)VARNAME_ID);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("evaluation_insert_formula");
        this.rawExpression.toTermOutput(pto);
        pto.printAtom("user");
        pto.printVariable(VARNAME_ID);
        pto.closeTerm();
    }

    public PrologTerm getId() {
        return this.id;
    }

    public static enum FormulaType {
        PREDICATE,
        EXPRESSION;

    }
}

