/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.AIntegerPrologTerm;
import de.prob.prolog.term.IntegerPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public final class ComputeCoverageCommand
implements IComposableCommand {
    private ComputeCoverageResult coverageResult;

    private ComputeCoverageCommand() {
    }

    public static ComputeCoverageResult getCoverage(Animator a) throws ProBException {
        ComputeCoverageCommand computeCoverageCommand = new ComputeCoverageCommand();
        a.execute(computeCoverageCommand);
        return computeCoverageCommand.getResult();
    }

    private ComputeCoverageResult getResult() {
        return this.coverageResult;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        AIntegerPrologTerm totalNodeNr = (AIntegerPrologTerm)bindings.get((Object)"TotalNodeNr");
        AIntegerPrologTerm totalTransNr = (AIntegerPrologTerm)bindings.get((Object)"TotalTransSum");
        ListPrologTerm ops = (ListPrologTerm)bindings.get((Object)"OpStat");
        ListPrologTerm nodes = (ListPrologTerm)bindings.get((Object)"NodeStat");
        ListPrologTerm uncovered = (ListPrologTerm)bindings.get((Object)"Uncovered");
        this.coverageResult = new ComputeCoverageResult(totalNodeNr, totalTransNr, ops, nodes, uncovered);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("compute_coverage").printVariable("TotalNodeNr").printVariable("TotalTransSum").printVariable("NodeStat").printVariable("OpStat").printVariable("Uncovered").closeTerm();
    }

    public static final class ComputeCoverageResult {
        private final BigInteger totalNumberOfNodes;
        private final BigInteger totalNumberOfTransitions;
        private final List<String> ops = new ArrayList<String>();
        private final List<String> nodes = new ArrayList<String>();
        private final List<String> uncovered = new ArrayList<String>();

        @Deprecated
        public ComputeCoverageResult(IntegerPrologTerm totalNumberOfNodes, IntegerPrologTerm totalNumberOfTransitions, ListPrologTerm ops, ListPrologTerm nodes, ListPrologTerm uncovered) {
            this((AIntegerPrologTerm)totalNumberOfNodes, (AIntegerPrologTerm)totalNumberOfTransitions, ops, nodes, uncovered);
        }

        public ComputeCoverageResult(AIntegerPrologTerm totalNumberOfNodes, AIntegerPrologTerm totalNumberOfTransitions, ListPrologTerm ops, ListPrologTerm nodes, ListPrologTerm uncovered) {
            this.totalNumberOfNodes = totalNumberOfNodes.getValue();
            this.totalNumberOfTransitions = totalNumberOfTransitions.getValue();
            for (PrologTerm op : ops) {
                this.getOps().add(op.getFunctor());
            }
            for (PrologTerm node : nodes) {
                this.getNodes().add(node.getFunctor());
            }
            for (PrologTerm unc : uncovered) {
                this.getUncovered().add(unc.getFunctor());
            }
        }

        public BigInteger getTotalNumberOfNodes() {
            return this.totalNumberOfNodes;
        }

        public BigInteger getTotalNumberOfTransitions() {
            return this.totalNumberOfTransitions;
        }

        public List<String> getOps() {
            return this.ops;
        }

        public List<String> getNodes() {
            return this.nodes;
        }

        public List<String> getUncovered() {
            return this.uncovered;
        }
    }
}

