/*
 * Decompiled with CFR 0.152.
 */
package de.prob.sap.commands;

import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.sap.util.FormulaUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eventb.core.ast.Predicate;

public class FindTestPathCommand
implements IComposableCommand {
    private final String COMMAND = "sap_find_test_path";
    private final String TRACE_VAR = "Trace";
    private final List<String> events;
    private final Predicate endPredicate;
    private final int timeout;
    private List<Operation> trace;
    private TestPathStatus status;

    public FindTestPathCommand(List<String> events, Predicate endPredicate, int timeout) {
        this.events = Collections.unmodifiableList(events);
        this.endPredicate = endPredicate;
        this.timeout = timeout <= 0 ? 0 : timeout;
    }

    public FindTestPathCommand(List<String> events, Predicate endPredicate) {
        this(events, endPredicate, 0);
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        ArrayList<Operation> trace;
        TestPathStatus status;
        PrologTerm answer = (PrologTerm)bindings.get((Object)"Trace");
        if (answer.hasFunctor("timeout", 0)) {
            status = TestPathStatus.TIMEOUT;
            trace = null;
        } else if (answer.hasFunctor("interrupt", 0)) {
            status = TestPathStatus.INTERRUPTED;
            trace = null;
        } else if (answer.isList()) {
            ListPrologTerm pTrace = (ListPrologTerm)answer;
            if (pTrace.isEmpty()) {
                status = TestPathStatus.NOT_FOUND;
                trace = null;
            } else {
                status = TestPathStatus.FOUND;
                trace = new ArrayList<Operation>(pTrace.size());
                for (PrologTerm opTerm : pTrace) {
                    CompoundPrologTerm cpt = (CompoundPrologTerm)opTerm;
                    trace.add(Operation.fromPrologTerm((PrologTerm)cpt));
                }
            }
        } else {
            throw new CommandException("Unexpected Prolog answer: " + String.valueOf(answer));
        }
        this.status = status;
        this.trace = trace;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("sap_find_test_path");
        pto.openList();
        for (String event : this.events) {
            pto.printAtom(event);
        }
        pto.closeList();
        FormulaUtils.printPredicate(this.endPredicate, pto);
        pto.printNumber((long)this.timeout);
        pto.printVariable("Trace");
        pto.closeTerm();
    }

    public List<Operation> getTrace() {
        return this.trace;
    }

    public TestPathStatus getStatus() {
        return this.status;
    }

    public static enum TestPathStatus {
        FOUND,
        NOT_FOUND,
        TIMEOUT,
        INTERRUPTED;

    }
}

