/*
 * Decompiled with CFR 0.152.
 */
package de.prob.logging;

import de.prob.core.internal.Activator;
import de.prob.exceptions.ProBAssertionFailed;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class Logger {
    public static void addListener(ILogListener listener) {
        Activator.getDefault().getLog().addLogListener(listener);
    }

    public static void notifyUser(String message, Throwable throwable) {
        Logger.log(4, message, throwable);
    }

    public static void notifyUser(String message) {
        Logger.notifyUser(message, null);
    }

    public static void assertProB(String assertion, boolean property) throws ProBAssertionFailed {
        if (!property) {
            StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
            Logger.notifyUser("ProB Assertion '" + assertion + "' failed in Class: " + caller.getClassName() + "\n Please submit a bugreport");
            throw new ProBAssertionFailed(assertion);
        }
    }

    public static void assertFail(String assertion) throws ProBAssertionFailed {
        Logger.assertProB(assertion, false);
    }

    public static void log(int severity, String message, Throwable exception) {
        Status status = new Status(severity, "de.prob.core", message, exception);
        Logger.log((IStatus)status);
    }

    public static void info(String message) {
        Status status = new Status(1, "de.prob.core", 0, message, null);
        Logger.log((IStatus)status);
    }

    private Logger() {
    }

    private static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }
}

