/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.types;

import de.prob.core.types.ProbDataType;
import java.util.Arrays;

public class OperationProbType
extends ProbDataType {
    private final ProbDataType[] results;
    private final ProbDataType[] parameters;

    public OperationProbType(ProbDataType[] results, ProbDataType[] parameters) {
        OperationProbType.checkValidTypeList(results, "result");
        OperationProbType.checkValidTypeList(parameters, "parameter");
        this.results = new ProbDataType[results.length];
        this.parameters = new ProbDataType[parameters.length];
        System.arraycopy(results, 0, this.results, 0, results.length);
        System.arraycopy(parameters, 0, this.parameters, 0, parameters.length);
    }

    private static void checkValidTypeList(ProbDataType[] list, String name) {
        if (list == null) {
            throw new IllegalArgumentException(name + " list of operation type must not be null");
        }
        ProbDataType[] probDataTypeArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            ProbDataType elem = probDataTypeArray[n2];
            if (elem == null) {
                throw new IllegalArgumentException(name + " list of operation type contains null type");
            }
            ++n2;
        }
    }

    @Override
    public int getOperatorPriority() {
        return this.results.length == 0 ? 500 : 150;
    }

    @Override
    public void prettyprint(StringBuilder builder) {
        if (this.results.length > 0) {
            OperationProbType.printTypeList(builder, this.results);
            builder.append("<--");
        }
        builder.append("op(");
        OperationProbType.printTypeList(builder, this.parameters);
        builder.append(")");
    }

    private static void printTypeList(StringBuilder builder, ProbDataType[] list) {
        if (list.length > 0) {
            if (list.length == 1) {
                list[0].prettyprint(builder);
            } else {
                boolean first = true;
                ProbDataType[] probDataTypeArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    ProbDataType elem = probDataTypeArray[n2];
                    if (!first) {
                        builder.append(',');
                    }
                    OperationProbType.printWithParenthesis(builder, elem, 116);
                    first = false;
                    ++n2;
                }
            }
        }
    }

    public boolean equals(Object other) {
        boolean isEqual;
        if (other == this) {
            isEqual = true;
        } else if (other != null && other instanceof OperationProbType) {
            OperationProbType opother = (OperationProbType)other;
            isEqual = Arrays.equals(this.results, opother.results) && Arrays.equals(this.parameters, opother.parameters);
        } else {
            isEqual = false;
        }
        return isEqual;
    }

    public int hashCode() {
        return (Arrays.hashCode(this.results) * 13 + Arrays.hashCode(this.parameters)) * 17 + 8;
    }
}

