/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.types;

import de.prob.core.types.ProbDataType;

public class CoupleProbType
extends ProbDataType {
    private final ProbDataType left;
    private final ProbDataType right;

    public CoupleProbType(ProbDataType left, ProbDataType right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Subtypes of couple data type must not be null");
        }
        this.left = left;
        this.right = right;
    }

    @Override
    public int getOperatorPriority() {
        return 190;
    }

    @Override
    public void prettyprint(StringBuilder builder) {
        CoupleProbType.printWithParenthesis(builder, this.left, this.getOperatorPriority());
        builder.append('*');
        CoupleProbType.printWithParenthesis(builder, this.right, this.getOperatorPriority() + 1);
    }

    public boolean equals(Object other) {
        boolean isEqual;
        if (other == this) {
            isEqual = true;
        } else if (other != null && other instanceof CoupleProbType) {
            CoupleProbType ocouple = (CoupleProbType)other;
            isEqual = this.left.equals(ocouple.left) && this.right.equals(ocouple.right);
        } else {
            isEqual = false;
        }
        return isEqual;
    }

    public int hashCode() {
        return (this.left.hashCode() * 13 + this.right.hashCode()) * 17 + 8;
    }
}

