/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleBinaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleNegation;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleUntil;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import java.util.ArrayList;
import java.util.List;

public final class CounterExampleRelease
extends CounterExampleBinaryOperator {
    public CounterExampleRelease(CounterExample counterExample, CounterExampleProposition firstArgument, CounterExampleProposition secondArgument) {
        super("R", "Release", counterExample, firstArgument, secondArgument);
        this.checkByUntil(counterExample, firstArgument, secondArgument);
    }

    private void checkByUntil(CounterExample counterExample, CounterExampleProposition firstArgument, CounterExampleProposition secondArgument) {
        CounterExampleNegation notFirst = new CounterExampleNegation(counterExample, firstArgument);
        CounterExampleNegation notSecond = new CounterExampleNegation(counterExample, secondArgument);
        CounterExampleUntil until = new CounterExampleUntil(counterExample, notFirst, notSecond);
        this.addCheck(new CounterExampleNegation(counterExample, until));
    }

    @Override
    protected CounterExampleValueType calculate(int position) {
        return this.calculateReleaseOperator(position);
    }

    private CounterExampleValueType calculateReleaseOperator(int position) {
        int unknownStateIndex;
        CounterExampleValueType result = CounterExampleValueType.UNKNOWN;
        List<CounterExampleValueType> firstCheckedValues = new ArrayList<CounterExampleValueType>(this.getFirstArgument().getValues());
        List<CounterExampleValueType> secondCheckedValues = new ArrayList<CounterExampleValueType>(this.getSecondArgument().getValues());
        if (this.pathType == LtlCheckingCommand.PathType.INFINITE && position > this.loopEntry) {
            firstCheckedValues.addAll(firstCheckedValues.subList(this.loopEntry, position));
            secondCheckedValues.addAll(secondCheckedValues.subList(this.loopEntry, position));
        }
        firstCheckedValues = firstCheckedValues.subList(position, firstCheckedValues.size());
        secondCheckedValues = secondCheckedValues.subList(position, secondCheckedValues.size());
        int secondIndex = -1;
        boolean trueOrUnknown = false;
        int firstIndex = firstCheckedValues.indexOf((Object)CounterExampleValueType.TRUE);
        if (firstIndex != -1) {
            secondIndex = secondCheckedValues.subList(0, firstIndex + 1).indexOf((Object)CounterExampleValueType.FALSE);
            if (secondIndex == -1) {
                trueOrUnknown = true;
                unknownStateIndex = this.indexOfUnknownState(firstCheckedValues = firstCheckedValues.subList(0, firstIndex + 1), secondCheckedValues = secondCheckedValues.subList(0, firstIndex + 1), false);
                if (unknownStateIndex != -1) {
                    firstCheckedValues = firstCheckedValues.subList(0, unknownStateIndex + 1);
                    secondCheckedValues = secondCheckedValues.subList(0, unknownStateIndex + 1);
                    firstIndex = -1;
                } else if (!secondCheckedValues.contains((Object)CounterExampleValueType.UNKNOWN)) {
                    result = CounterExampleValueType.TRUE;
                } else {
                    firstIndex = -1;
                }
            }
        } else if (this.pathType != LtlCheckingCommand.PathType.REDUCED && !secondCheckedValues.contains((Object)CounterExampleValueType.FALSE)) {
            trueOrUnknown = true;
            result = CounterExampleValueType.TRUE;
            firstCheckedValues.clear();
        }
        if (!trueOrUnknown) {
            secondIndex = secondCheckedValues.indexOf((Object)CounterExampleValueType.FALSE);
            if (secondIndex != -1) {
                firstCheckedValues = firstCheckedValues.subList(0, secondIndex);
                firstIndex = -1;
                if (!firstCheckedValues.contains((Object)CounterExampleValueType.UNKNOWN)) {
                    result = CounterExampleValueType.FALSE;
                } else {
                    unknownStateIndex = this.indexOfUnknownState(firstCheckedValues, secondCheckedValues.subList(0, secondIndex), false);
                    if (unknownStateIndex != -1) {
                        firstCheckedValues = firstCheckedValues.subList(0, unknownStateIndex + 1);
                        secondCheckedValues = secondCheckedValues.subList(0, unknownStateIndex + 1);
                    } else {
                        secondCheckedValues = secondCheckedValues.subList(0, secondIndex + 1);
                        secondIndex = -1;
                    }
                    secondIndex = -1;
                }
            } else {
                unknownStateIndex = this.indexOfUnknownState(firstCheckedValues, secondCheckedValues, false);
                if (unknownStateIndex != -1) {
                    firstCheckedValues = firstCheckedValues.subList(0, unknownStateIndex + 1);
                    secondCheckedValues = secondCheckedValues.subList(0, unknownStateIndex + 1);
                }
            }
        }
        this.fillHighlightedPositions(position, firstIndex, secondIndex, firstCheckedValues.size(), secondCheckedValues.size(), false);
        return result;
    }
}

