/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import de.prob.logging.Logger;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class CounterExampleProposition {
    protected final String name;
    protected final String fullName;
    protected final int loopEntry;
    protected final LtlCheckingCommand.PathType pathType;
    protected final CounterExample counterExample;
    protected CounterExampleProposition parent;
    private List<CounterExampleValueType> values;
    private Collection<CounterExampleProposition> checks = new ArrayList<CounterExampleProposition>();
    protected final PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private boolean visible = false;
    protected int stateId = 0;

    public CounterExampleProposition(String name, String fullName, CounterExample counterExample) {
        this.name = name;
        this.fullName = fullName;
        this.loopEntry = counterExample.getLoopEntry();
        this.pathType = counterExample.getPathType();
        this.counterExample = counterExample;
    }

    public CounterExampleProposition getParent() {
        return this.parent;
    }

    public void setParent(CounterExampleProposition parent) {
        this.parent = parent;
    }

    public String getFullName() {
        return this.fullName;
    }

    public List<CounterExampleValueType> getValues() {
        if (this.values == null) {
            this.values = this.calculate();
            this.performChecks(this.values);
        }
        return this.values;
    }

    public List<CounterExampleProposition> getChildren() {
        ArrayList<CounterExampleProposition> children = new ArrayList<CounterExampleProposition>();
        children.add(this);
        return children;
    }

    public abstract boolean hasChildren();

    public LtlCheckingCommand.PathType getPathType() {
        return this.pathType;
    }

    public int getLoopEntry() {
        return this.loopEntry;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.visible;
        this.visible = visible;
        this.listeners.firePropertyChange("visible", oldVisible, visible);
    }

    public int getStateId() {
        return this.stateId;
    }

    public void setStateId(int stateId) {
        int oldStateId = this.stateId;
        this.stateId = stateId;
        this.listeners.firePropertyChange("stateId", oldStateId, stateId);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    protected List<Integer> fillPositions(int position, int index, int checkedSize, boolean isPastOperator) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        if (index != -1) {
            int pos = isPastOperator ? index : index + position;
            pos = this.calculatePosition(pos);
            Logger.assertProB("Position invalid", pos >= 0);
            positions.add(pos);
        } else {
            int i = 0;
            while (i < checkedSize) {
                int pos = isPastOperator ? position - i : position + i;
                pos = this.calculatePosition(pos);
                Logger.assertProB("Position invalid", pos >= 0);
                positions.add(pos);
                ++i;
            }
        }
        return positions;
    }

    public boolean isTransition() {
        return false;
    }

    protected abstract List<CounterExampleValueType> calculate();

    private int calculatePosition(int pos) {
        int size = this.counterExample.getCounterExampleSize();
        return pos < size ? pos : pos - (size - this.loopEntry);
    }

    protected final void addCheck(CounterExampleProposition check) {
        this.checks.add(check);
    }

    private void performChecks(List<CounterExampleValueType> values) {
        for (CounterExampleProposition check : this.checks) {
            this.performCheck(check, values);
        }
    }

    private void performCheck(CounterExampleProposition check, List<CounterExampleValueType> values) {
        List<CounterExampleValueType> values2 = check.getValues();
        if (!values.equals(values2)) {
            Logger.notifyUser("Encountered inconsistency in computation of LTL operator" + this.name);
        }
    }
}

