/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleBinaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleDisjunction;
import de.prob.core.domainobjects.ltl.CounterExampleNegation;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;

public final class CounterExampleImplication
extends CounterExampleBinaryOperator {
    public CounterExampleImplication(CounterExample counterExample, CounterExampleProposition firstArgument, CounterExampleProposition secondArgument) {
        super("=>", "Implication", counterExample, firstArgument, secondArgument);
    }

    @Override
    protected CounterExampleValueType calculate(int position) {
        CounterExampleValueType firstValue = this.getFirstArgument().getValues().get(position);
        firstValue = CounterExampleNegation.calculateNotOperator(firstValue);
        CounterExampleValueType secondValue = this.getSecondArgument().getValues().get(position);
        int firstCheckedSize = 1;
        int secondCheckedSize = 1;
        if (firstValue == CounterExampleValueType.TRUE) {
            secondCheckedSize = 0;
        } else if (secondValue == CounterExampleValueType.TRUE) {
            firstCheckedSize = 0;
        }
        this.fillHighlightedPositions(position, -1, -1, firstCheckedSize, secondCheckedSize, false);
        return CounterExampleDisjunction.calculateOr(firstValue, secondValue);
    }
}

