/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleNegation;
import de.prob.core.domainobjects.ltl.CounterExampleOnce;
import de.prob.core.domainobjects.ltl.CounterExamplePredicate;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleSince;
import de.prob.core.domainobjects.ltl.CounterExampleUnaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CounterExampleHistory
extends CounterExampleUnaryOperator {
    public CounterExampleHistory(CounterExample counterExample, CounterExampleProposition argument) {
        super("H", "History", counterExample, argument);
        CounterExampleNegation notArgument = new CounterExampleNegation(counterExample, argument);
        this.checkByOnce(counterExample, notArgument);
        this.checkBySince(counterExample, argument, notArgument);
    }

    private void checkBySince(CounterExample counterExample, CounterExampleProposition argument, CounterExampleNegation notArgument) {
        CounterExampleValueType[] trueValues = new CounterExampleValueType[argument.getValues().size()];
        Arrays.fill((Object[])trueValues, (Object)CounterExampleValueType.TRUE);
        CounterExamplePredicate truePredicate = new CounterExamplePredicate("", counterExample, Arrays.asList(trueValues));
        CounterExampleSince since = new CounterExampleSince(counterExample, truePredicate, notArgument);
        this.addCheck(new CounterExampleNegation(counterExample, since));
    }

    private void checkByOnce(CounterExample counterExample, CounterExampleNegation notArgument) {
        CounterExampleOnce onceOperator = new CounterExampleOnce(counterExample, notArgument);
        this.addCheck(new CounterExampleNegation(counterExample, onceOperator));
    }

    @Override
    public CounterExampleValueType calculate(int position) {
        return this.calculateHistoryOperator(position);
    }

    private CounterExampleValueType calculateHistoryOperator(int position) {
        CounterExampleValueType result = CounterExampleValueType.UNKNOWN;
        List<CounterExampleValueType> checkedValues = new ArrayList<CounterExampleValueType>(this.argument.getValues());
        int index = (checkedValues = checkedValues.subList(0, position + 1)).lastIndexOf((Object)CounterExampleValueType.FALSE);
        if (index != -1) {
            result = CounterExampleValueType.FALSE;
        } else if (!checkedValues.contains((Object)CounterExampleValueType.UNKNOWN)) {
            result = CounterExampleValueType.TRUE;
        }
        this.fillHighlightedPositions(position, index, checkedValues.size(), true);
        return result;
    }
}

