/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleFinally;
import de.prob.core.domainobjects.ltl.CounterExampleNegation;
import de.prob.core.domainobjects.ltl.CounterExamplePredicate;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleRelease;
import de.prob.core.domainobjects.ltl.CounterExampleUnaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleUntil;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CounterExampleGlobally
extends CounterExampleUnaryOperator {
    public CounterExampleGlobally(CounterExample counterExample, CounterExampleProposition argument) {
        super("G", "Globally", counterExample, argument);
        this.checkByRelease(counterExample, argument);
        CounterExampleNegation notArgument = new CounterExampleNegation(counterExample, argument);
        this.checkByFinally(counterExample, notArgument);
        this.checkByUntil(counterExample, argument, notArgument);
    }

    private void checkByUntil(CounterExample counterExample, CounterExampleProposition argument, CounterExampleNegation notArgument) {
        CounterExampleValueType[] trueValues = new CounterExampleValueType[argument.getValues().size()];
        Arrays.fill((Object[])trueValues, (Object)CounterExampleValueType.TRUE);
        CounterExamplePredicate truePredicate = new CounterExamplePredicate("", counterExample, Arrays.asList(trueValues));
        CounterExampleUntil until = new CounterExampleUntil(counterExample, truePredicate, notArgument);
        this.addCheck(new CounterExampleNegation(counterExample, until));
    }

    private void checkByFinally(CounterExample counterExample, CounterExampleNegation notArgument) {
        CounterExampleFinally finallyOperator = new CounterExampleFinally(counterExample, notArgument);
        this.addCheck(new CounterExampleNegation(counterExample, finallyOperator));
    }

    private void checkByRelease(CounterExample counterExample, CounterExampleProposition argument) {
        CounterExampleValueType[] falseValues = new CounterExampleValueType[argument.getValues().size()];
        Arrays.fill((Object[])falseValues, (Object)CounterExampleValueType.FALSE);
        CounterExamplePredicate falsePredicate = new CounterExamplePredicate("", counterExample, Arrays.asList(falseValues));
        this.addCheck(new CounterExampleRelease(counterExample, falsePredicate, argument));
    }

    @Override
    protected CounterExampleValueType calculate(int position) {
        int index;
        CounterExampleValueType result = CounterExampleValueType.UNKNOWN;
        List<CounterExampleValueType> checkedValues = new ArrayList<CounterExampleValueType>(this.argument.getValues());
        if (this.pathType == LtlCheckingCommand.PathType.INFINITE && position > this.loopEntry) {
            checkedValues.addAll(checkedValues.subList(this.loopEntry, position));
        }
        if ((index = (checkedValues = checkedValues.subList(position, checkedValues.size())).indexOf((Object)CounterExampleValueType.FALSE)) != -1) {
            result = CounterExampleValueType.FALSE;
        } else if (this.pathType != LtlCheckingCommand.PathType.REDUCED) {
            result = CounterExampleValueType.TRUE;
        }
        this.fillHighlightedPositions(position, index, checkedValues.size(), false);
        return result;
    }
}

