/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.eval;

import de.be4.classicalb.core.parser.BParser;
import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.node.Start;
import de.prob.core.Animator;
import de.prob.core.command.EvaluateRawExpressionsCommand;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;

public abstract class AbstractEvalElement {
    private String value = null;
    private Animator animator;

    public abstract Start getPrologAst();

    public abstract boolean hasChildren();

    public boolean isAtomic() {
        return !this.hasChildren();
    }

    public abstract String getLabel();

    protected Start parse(String prefix, String code) throws BCompoundException {
        BParser parser = new BParser();
        Start modelAst = parser.parse(prefix + code, false);
        return modelAst;
    }

    public synchronized String getValue(Animator animator, String stateId) {
        this.animator = animator;
        if (this.value == null) {
            this.value = this.evaluate(stateId);
        }
        return this.value;
    }

    private synchronized String evaluate(String stateId) {
        try {
            return EvaluateRawExpressionsCommand.evaluate(this.animator, this, stateId);
        }
        catch (ProBException e) {
            Logger.notifyUser("Something went wrong while evaluating: " + this.getLabel(), e);
            return "unknown value";
        }
    }
}

