/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects;

import de.prob.prolog.term.AIntegerPrologTerm;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.unicode.UnicodeTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Operation {
    private static final String INTERNAL_NAME_INITIALISE_MACHINE = "$initialise_machine";
    private static final String INTERNAL_NAME_SETUP_CONSTANTS = "$setup_constants";
    private static final Map<String, EventType> SPECIAL_EVENTS = Operation.createSpecialEvents();
    public static final Operation NULL_OPERATION = new Operation("no operation");
    private final EventType eventType;
    private final long id;
    private final String name;
    private final String dest;
    private final String src;
    private final List<PrologTerm> args;
    private final List<String> argsPretty;
    private final List<EventStackElement> eventStack;
    private static final int ID = 1;
    private static final int NAME = 2;
    private static final int SRC = 3;
    private static final int DST = 4;
    private static final int ARGS = 5;
    private static final int ARGS_PRETTY = 6;
    private static final int INFOS = 7;
    private final int hashCode;

    public static String getInternalName(String displayname) {
        if (displayname.equals("SETUP_CONTEXT")) {
            return INTERNAL_NAME_SETUP_CONSTANTS;
        }
        if (displayname.equals("INITIALISATION")) {
            return INTERNAL_NAME_INITIALISE_MACHINE;
        }
        return displayname;
    }

    @Deprecated
    Operation(String name) {
        EventType type = SPECIAL_EVENTS.get(name);
        this.id = -1L;
        this.eventType = type == null ? EventType.NORMAL_EVENT : type;
        this.name = type == null ? name : type.getDisplayName();
        this.dest = null;
        this.src = null;
        this.eventStack = null;
        this.args = new ArrayList<PrologTerm>(0);
        this.argsPretty = new ArrayList<String>(0);
        this.hashCode = this.initHashCode();
    }

    private static Map<String, EventType> createSpecialEvents() {
        HashMap<String, EventType> specialEvents = new HashMap<String, EventType>();
        specialEvents.put(INTERNAL_NAME_SETUP_CONSTANTS, EventType.SETUP_CONTEXT);
        specialEvents.put(INTERNAL_NAME_INITIALISE_MACHINE, EventType.INITIALISATION);
        return Collections.unmodifiableMap(specialEvents);
    }

    public static Operation fromPrologTerm(PrologTerm rawOpTerm) {
        CompoundPrologTerm opTerm = (CompoundPrologTerm)rawOpTerm;
        AIntegerPrologTerm pInt = (AIntegerPrologTerm)opTerm.getArgument(1);
        long id = pInt.longValueExact();
        String name = PrologTerm.atomicString((PrologTerm)opTerm.getArgument(2));
        EventType type = SPECIAL_EVENTS.get(name);
        String destId = Operation.getIdFromPrologTerm(opTerm.getArgument(4));
        String srcId = Operation.getIdFromPrologTerm(opTerm.getArgument(3));
        ListPrologTerm args = (ListPrologTerm)opTerm.getArgument(5);
        List<String> pargs = Operation.create_pretty_arguments((List<PrologTerm>)((ListPrologTerm)opTerm.getArgument(6)));
        List<EventStackElement> eventStack = Operation.createEventStack((ListPrologTerm)opTerm.getArgument(7));
        return new Operation(id, type, name, destId, srcId, (List<PrologTerm>)args, pargs, eventStack);
    }

    @Deprecated
    public Operation(CompoundPrologTerm term) {
        String preName = PrologTerm.atomicString((PrologTerm)term.getArgument(2));
        EventType type = SPECIAL_EVENTS.get(preName);
        this.eventType = type == null ? EventType.NORMAL_EVENT : type;
        this.name = type == null ? preName : type.getDisplayName();
        this.dest = Operation.getIdFromPrologTerm(term.getArgument(4));
        this.src = Operation.getIdFromPrologTerm(term.getArgument(3));
        this.args = (ListPrologTerm)term.getArgument(5);
        this.argsPretty = Operation.create_pretty_arguments((List<PrologTerm>)((ListPrologTerm)term.getArgument(6)));
        this.hashCode = this.initHashCode();
        AIntegerPrologTerm pInt = (AIntegerPrologTerm)term.getArgument(1);
        this.id = pInt.longValueExact();
        this.eventStack = Operation.createEventStack((ListPrologTerm)term.getArgument(7));
    }

    private Operation(long id, EventType type, String name, String destId, String srcId, List<PrologTerm> prologArgs, List<String> stringArgs, List<EventStackElement> eventStack) {
        this.id = id;
        this.eventType = type;
        this.name = type == null ? name : type.getDisplayName();
        this.dest = destId;
        this.src = srcId;
        this.args = prologArgs;
        this.argsPretty = stringArgs;
        this.eventStack = eventStack;
        this.hashCode = this.initHashCode();
    }

    private static List<String> create_pretty_arguments(List<PrologTerm> argsPrettyTerm) {
        ArrayList<String> argsPretty = new ArrayList<String>(argsPrettyTerm.size());
        for (PrologTerm ppTerm : argsPrettyTerm) {
            String ppArg = PrologTerm.atomicString((PrologTerm)ppTerm);
            String niceArg = UnicodeTranslator.toUnicode((String)ppArg);
            argsPretty.add(niceArg);
        }
        return Collections.unmodifiableList(argsPretty);
    }

    private static List<EventStackElement> createEventStack(ListPrologTerm list) {
        for (PrologTerm term : list) {
            if (!term.hasFunctor("event", 1)) continue;
            ListPrologTerm pstack = (ListPrologTerm)((CompoundPrologTerm)term).getArgument(1);
            ArrayList<EventStackElement> stack = new ArrayList<EventStackElement>(pstack.size());
            for (PrologTerm elem : pstack) {
                stack.add(Operation.extractStackElement(elem));
            }
            return Collections.unmodifiableList(stack);
        }
        return null;
    }

    private static EventStackElement extractStackElement(PrologTerm elem) {
        if (elem.hasFunctor("event", 2)) {
            List<String> sparams;
            CompoundPrologTerm term = (CompoundPrologTerm)elem;
            String name = PrologTerm.atomicString((PrologTerm)term.getArgument(1));
            ListPrologTerm pparams = (ListPrologTerm)term.getArgument(2);
            if (pparams.isEmpty()) {
                sparams = Collections.emptyList();
            } else {
                sparams = new ArrayList(pparams.size());
                for (PrologTerm p : pparams) {
                    sparams.add(PrologTerm.atomicString((PrologTerm)p));
                }
                sparams = Collections.unmodifiableList(sparams);
            }
            return new EventStackElement(name, sparams);
        }
        throw new IllegalArgumentException("expected event/2 but was: " + String.valueOf(elem));
    }

    private static String getIdFromPrologTerm(PrologTerm destTerm) {
        return destTerm.atomicToString();
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDestination() {
        return this.dest;
    }

    public String getSource() {
        return this.src;
    }

    public List<String> getArguments() {
        return this.argsPretty;
    }

    public List<PrologTerm> getRawArguments() {
        return Collections.unmodifiableList(this.args);
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public List<EventStackElement> getEventStack() {
        return this.eventStack;
    }

    public String toString() {
        if (this.argsPretty.isEmpty()) {
            return this.name;
        }
        return this.name + "(" + String.join((CharSequence)",", this.argsPretty) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != NULL_OPERATION && o != null && o instanceof Operation) {
            Operation op = (Operation)o;
            return this.id == op.id && op.src.equals(this.src) && op.dest.equals(this.dest) && op.name.equals(this.name) && op.argsPretty.equals(this.argsPretty);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int initHashCode() {
        int result = 527 + (this.src == null ? 0 : this.src.hashCode());
        result = 31 * result + (this.dest == null ? 0 : this.dest.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        for (String arg : this.argsPretty) {
            result = 31 * result + (arg == null ? 0 : arg.hashCode());
        }
        return result * 31 + (int)this.id;
    }

    public static class EventStackElement {
        private final String eventName;
        private final List<String> parameters;

        public EventStackElement(String eventName, List<String> parameters) {
            this.eventName = eventName;
            this.parameters = parameters;
        }

        public String getEventName() {
            return this.eventName;
        }

        public List<String> getParameters() {
            return this.parameters;
        }
    }

    public static enum EventType {
        SETUP_CONTEXT("SETUP_CONTEXT"),
        INITIALISATION("INITIALISATION"),
        NORMAL_EVENT(null);

        private final String displayName;

        private EventType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

