/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.List;

public class ModelCheckingResult<T extends Enum<T>> {
    private final T result;
    private final List<PrologTerm> arguments = new ArrayList<PrologTerm>();
    private final int processedTotal;
    private final int numStates;
    private final int numTransitions;

    public ModelCheckingResult(Class<T> enumeration, CompoundPrologTerm term, int total, int numStates, int numTransitions) {
        this.result = Enum.valueOf(enumeration, term.getFunctor());
        int i = 1;
        while (i <= term.getArity()) {
            this.arguments.add(term.getArgument(i));
            ++i;
        }
        this.processedTotal = total;
        this.numStates = numStates;
        this.numTransitions = numTransitions;
    }

    public PrologTerm getArgument(int i) {
        return this.arguments.get(i);
    }

    public T getResult() {
        return this.result;
    }

    public int getProcessedTotal() {
        return this.processedTotal;
    }

    public int getNumStates() {
        return this.numStates;
    }

    public int getNumTransitions() {
        return this.numTransitions;
    }

    public int getWorked() {
        return (int)(1000.0 * Math.pow((double)this.processedTotal / (double)this.numStates, 5.0));
    }
}

