/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.LanguageDependendAnimationPart;
import de.prob.core.command.ClearMachineCommand;
import de.prob.core.command.CommandException;
import de.prob.core.command.ComposedCommand;
import de.prob.core.command.ExploreStateCommand;
import de.prob.core.command.GetMachineObjectsCommand;
import de.prob.core.command.GetPreferencesCommand;
import de.prob.core.command.SetPreferencesCommand;
import de.prob.core.command.StartAnimationCommand;
import de.prob.core.command.internal.InternalLoadCommand;
import de.prob.core.domainobjects.MachineDescription;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.ProBPreference;
import de.prob.core.domainobjects.State;
import de.prob.core.langdep.EventBAnimatorPart;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.output.StructuredPrologOutput;
import de.prob.prolog.term.PrologTerm;
import java.util.HashSet;
import java.util.List;
import org.eventb.core.IContextRoot;
import org.eventb.core.IEventBRoot;
import org.eventb.core.IMachineRoot;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.rodinp.core.RodinDBException;

public final class LoadEventBModelCommand {
    private static boolean preferencesAlreadyCleanedUp = false;

    private LoadEventBModelCommand() {
        throw new UnsupportedOperationException("Do not instantiate this class");
    }

    private LoadEventBModelCommand(IEventBRoot model) {
    }

    private static boolean checkForContexts(IEventBRoot model) {
        if (model instanceof IContextRoot) {
            return true;
        }
        try {
            if (model instanceof IMachineRoot) {
                IMachineRoot r = (IMachineRoot)model;
                return r.getSeesClauses().length != 0;
            }
        }
        catch (RodinDBException rodinDBException) {}
        return false;
    }

    public static PrologTerm toPrologTerm(IEventBRoot model) throws CommandException {
        StructuredPrologOutput out = new StructuredPrologOutput();
        InternalLoadCommand load = new InternalLoadCommand(model);
        load.writeCommand((IPrologTermOutput)out);
        out.fullstop();
        return (PrologTerm)out.getSentences().iterator().next();
    }

    public static void load(Animator animator, IEventBRoot model) throws ProBException {
        boolean context = LoadEventBModelCommand.checkForContexts(model);
        animator.resetDirty();
        LoadEventBModelCommand.removeObsoletePreferences(animator);
        EventBAnimatorPart ldp = new EventBAnimatorPart(model);
        ClearMachineCommand clear = new ClearMachineCommand();
        SetPreferencesCommand setPrefs = SetPreferencesCommand.createSetPreferencesCommand(animator);
        InternalLoadCommand load = new InternalLoadCommand(model);
        StartAnimationCommand start = new StartAnimationCommand();
        SetMachineObjectsCommand getMObjects = new SetMachineObjectsCommand(animator, ldp);
        ExploreStateCommand explore = new ExploreStateCommand("root");
        ComposedCommand composed = new ComposedCommand(clear, setPrefs, load, start, getMObjects, explore);
        try {
            animator.execute(composed);
            State commandResult = explore.getState();
            animator.announceCurrentStateChanged(commandResult, Operation.NULL_OPERATION);
            if (commandResult.isTimeoutOccured() && context) {
                int solsFound = explore.getState().getEnabledOperations().size();
                Object message = solsFound > 0 ? "A timeout occured when finding constants after finding " + solsFound + " solution(s). Typically this means, that your axioms are too complicated for automatic solving. You might create an animation refinement using the context menu to help ProB finding all solutions." : "A timeout occured when finding constants. Typically this means, that your axioms are too complicated for automatic solving. You might create an animation refinement using the context menu to help ProB finding a solution.";
                Logger.notifyUser((String)message);
            }
        }
        catch (CommandException ex) {
            Logger.notifyUser("Event-B Model or Context could not be loaded due to an exception: " + ex.getMessage() + "\nTry cleaning the Rodin project (Project -> Clean).", ex);
        }
    }

    private static void removeObsoletePreferences(Animator animator) throws ProBException {
        if (!preferencesAlreadyCleanedUp) {
            List<ProBPreference> prefs = GetPreferencesCommand.getPreferences(animator);
            HashSet<String> probPrefNames = new HashSet<String>();
            for (ProBPreference probpref : prefs) {
                probPrefNames.add(probpref.name);
            }
            Preferences preferences = SetPreferencesCommand.getPreferences();
            try {
                boolean foundObsoletePreference = false;
                String[] stringArray = preferences.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String prefname = stringArray[n2];
                    if (!probPrefNames.contains(prefname)) {
                        preferences.remove(prefname);
                        foundObsoletePreference = true;
                        String message = "removed obsolete preference from preferences store: " + prefname;
                        Logger.info(message);
                    }
                    ++n2;
                }
                if (foundObsoletePreference) {
                    preferences.flush();
                }
            }
            catch (BackingStoreException e) {
                Logger.notifyUser("Error while accessing ProB Preferences", e);
            }
            preferencesAlreadyCleanedUp = true;
        }
    }

    private static class SetMachineObjectsCommand
    extends GetMachineObjectsCommand {
        private final Animator animator;
        private final LanguageDependendAnimationPart ldp;

        public SetMachineObjectsCommand(Animator animator, LanguageDependendAnimationPart ldp) {
            this.animator = animator;
            this.ldp = ldp;
        }

        @Override
        public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
            super.processResult(bindings);
            this.animator.setMachineDescription(new MachineDescription(this.getResult()));
            this.animator.setLanguageDependendPart(this.ldp);
            this.animator.announceReset();
        }
    }
}

