/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class GetTraceCommand
implements IComposableCommand {
    private static final String TRACE_VARIABLE = "Trace";
    private List<String> trace;

    private GetTraceCommand() {
    }

    public static List<String> getTrace(Animator a) throws ProBException {
        GetTraceCommand getTraceCommand = new GetTraceCommand();
        a.execute(getTraceCommand);
        return getTraceCommand.getTrace();
    }

    private List<String> getTrace() {
        return this.trace;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        LinkedList<Occurence> res = new LinkedList<Occurence>();
        ListPrologTerm list = (ListPrologTerm)bindings.get((Object)TRACE_VARIABLE);
        Occurence current = null;
        for (PrologTerm term : list) {
            if (current == null || !current.text.equals(term.toString())) {
                current = new Occurence(term.toString());
                res.add(current);
                continue;
            }
            current.inc();
        }
        ArrayList<String> actions = new ArrayList<String>();
        for (Occurence occurence : res) {
            actions.add(occurence.toString());
        }
        this.trace = actions;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("find_shortest_trace_to_current_state").printVariable(TRACE_VARIABLE).closeTerm();
    }

    private static final class Occurence {
        private final String text;
        private int count;

        public Occurence(String text) {
            this.text = text;
            this.count = 1;
        }

        public synchronized void inc() {
            ++this.count;
        }

        public synchronized String toString() {
            return this.text + (String)(this.count > 1 ? " (" + this.count + " times)" : "");
        }
    }
}

