/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class GetCurrentStateIdCommand
implements IComposableCommand {
    private String currentID;

    public static String getStateID(PrologTerm term) {
        String result = term.isAtom() ? PrologTerm.atomicString((PrologTerm)term) : term.toString();
        return result;
    }

    public static List<String> getStateIDs(Collection<PrologTerm> terms) {
        ArrayList<String> ids = new ArrayList<String>(terms.size());
        for (PrologTerm term : terms) {
            ids.add(GetCurrentStateIdCommand.getStateID(term));
        }
        return ids;
    }

    private GetCurrentStateIdCommand() {
    }

    public static String getID(Animator a) throws ProBException {
        GetCurrentStateIdCommand cmd = new GetCurrentStateIdCommand();
        a.execute(cmd);
        return cmd.getCurrentStateId();
    }

    private String getCurrentStateId() {
        return this.currentID;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        this.currentID = GetCurrentStateIdCommand.getStateID((PrologTerm)bindings.get((Object)"ID"));
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("getCurrentStateID").printVariable("ID").closeTerm();
    }
}

