/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.PrologTerm;

public class FindValidStateCommand
implements IComposableCommand {
    private static final String COMMAND_NAME = "find_state_satisfying_predicate";
    private static final String RESULT_VARIABLE = "R";
    private final PrologTerm predicate;
    private ResultType result;
    private String stateId;
    private Operation operation;

    public FindValidStateCommand(PrologTerm predicate) {
        this.predicate = predicate;
    }

    public PrologTerm getPredicate() {
        return this.predicate;
    }

    public ResultType getResult() {
        return this.result;
    }

    public String getStateId() {
        return this.stateId;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(COMMAND_NAME);
        if (this.predicate != null) {
            this.predicate.toTermOutput(pto);
        }
        pto.printVariable(RESULT_VARIABLE);
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        ResultType result;
        PrologTerm resultTerm = (PrologTerm)bindings.get((Object)RESULT_VARIABLE);
        if (resultTerm.hasFunctor("no_valid_state_found", 0)) {
            result = ResultType.NO_STATE_FOUND;
        } else if (resultTerm.hasFunctor("errors", 1)) {
            result = ResultType.ERROR;
        } else if (resultTerm.hasFunctor("interrupted", 0)) {
            result = ResultType.INTERRUPTED;
        } else if (resultTerm.hasFunctor("state_found", 2)) {
            CompoundPrologTerm term = (CompoundPrologTerm)resultTerm;
            result = ResultType.STATE_FOUND;
            this.operation = Operation.fromPrologTerm(term.getArgument(1));
            this.stateId = term.getArgument(2).toString();
        } else {
            throw new CommandException("unexpected result when trying to find a valid state: " + String.valueOf(resultTerm));
        }
        this.result = result;
    }

    public static enum ResultType {
        STATE_FOUND,
        NO_STATE_FOUND,
        INTERRUPTED,
        ERROR;

    }
}

