/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CheckBooleanPropertyCommand;
import de.prob.core.command.CheckInitialisationStatusCommand;
import de.prob.core.command.CheckInvariantStatusCommand;
import de.prob.core.command.CheckMaxOperationReachedStatusCommand;
import de.prob.core.command.CheckTimeoutStatusCommand;
import de.prob.core.command.CommandException;
import de.prob.core.command.ComposedCommand;
import de.prob.core.command.GetEnabledOperationsCommand;
import de.prob.core.command.GetStateBasedErrorsCommand;
import de.prob.core.command.GetStateValuesCommand;
import de.prob.core.command.GetTimeoutedOperationsCommand;
import de.prob.core.command.IComposableCommand;
import de.prob.core.command.QuickDescribeUnsatPropertiesCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.core.domainobjects.StateError;
import de.prob.core.domainobjects.Variable;
import de.prob.core.internal.Activator;
import de.prob.exceptions.ProBException;
import de.prob.logging.Logger;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class ExploreStateCommand
implements IComposableCommand {
    private final String stateId;
    private final GetEnabledOperationsCommand getOpsCmd;
    private final GetStateValuesCommand getValuesCmd;
    private final CheckBooleanPropertyCommand checkInitialisedCmd;
    private final CheckBooleanPropertyCommand checkInvCmd;
    private final CheckBooleanPropertyCommand checkMaxOpCmd;
    private final CheckBooleanPropertyCommand checkTimeoutCmd;
    private final GetStateBasedErrorsCommand getStateErrCmd;
    private final QuickDescribeUnsatPropertiesCommand unsatPropsCommand;
    private final ComposedCommand allCommands;
    private State state;
    private final GetTimeoutedOperationsCommand checkTimeoutOpsCmd;

    public ExploreStateCommand(String stateID) {
        this.stateId = stateID;
        this.getOpsCmd = new GetEnabledOperationsCommand(this.stateId);
        this.getValuesCmd = new GetStateValuesCommand(this.stateId);
        this.checkInitialisedCmd = new CheckInitialisationStatusCommand(this.stateId);
        this.checkInvCmd = new CheckInvariantStatusCommand(this.stateId);
        this.checkMaxOpCmd = new CheckMaxOperationReachedStatusCommand(this.stateId);
        this.checkTimeoutCmd = new CheckTimeoutStatusCommand(this.stateId);
        this.checkTimeoutOpsCmd = new GetTimeoutedOperationsCommand(this.stateId);
        this.getStateErrCmd = new GetStateBasedErrorsCommand(this.stateId);
        this.unsatPropsCommand = new QuickDescribeUnsatPropertiesCommand();
        this.allCommands = new ComposedCommand(this.getOpsCmd, this.getValuesCmd, this.checkInitialisedCmd, this.checkInvCmd, this.checkMaxOpCmd, this.checkTimeoutCmd, this.checkTimeoutOpsCmd, this.getStateErrCmd, this.unsatPropsCommand);
    }

    public static State exploreState(Animator a, String stateID) throws ProBException {
        ExploreStateCommand command = new ExploreStateCommand(stateID);
        a.execute(command);
        return command.getState();
    }

    public String getStateID() {
        return this.stateId;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        this.allCommands.processResult(bindings);
        boolean initialised = this.checkInitialisedCmd.getResult();
        boolean invariantOk = this.checkInvCmd.getResult();
        boolean timeoutOccured = this.checkTimeoutCmd.getResult();
        boolean maxOperationsReached = this.checkMaxOpCmd.getResult();
        boolean unsatPropertiesExist = this.unsatPropsCommand.unsatPropertiesExist();
        List<Operation> enabledOperations = this.getOpsCmd.getEnabledOperations();
        List<Variable> variables = this.getValuesCmd.getResult();
        Collection<StateError> stateErrors = this.getStateErrCmd.getResult();
        if (unsatPropertiesExist) {
            Logger.notifyUser("ProB could not find valid constants wich satisfy the properties.\n" + this.unsatPropsCommand.getUnsatPropertiesDescription());
        } else if (!initialised && enabledOperations.isEmpty() && !timeoutOccured) {
            Logger.notifyUser("ProB could not find valid constants/variables. This might be caused by the animation settings (e.g., Integer range or deferred set size) or by an inconsistency in the axioms.");
        }
        HashSet<String> timeouts = new HashSet<String>(this.checkTimeoutOpsCmd.getTimeouts());
        this.state = new State(this.stateId, initialised, invariantOk, timeoutOccured, maxOperationsReached, variables, enabledOperations, stateErrors, timeouts);
        Activator.computedState(this.state);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) throws CommandException {
        this.allCommands.writeCommand(pto);
    }

    public State getState() {
        return this.state;
    }
}

