/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core;

import de.prob.cli.CliException;
import de.prob.core.PrologException;
import de.prob.core.command.CommandException;
import de.prob.logging.Logger;
import java.util.List;

public class ProblemHandler {
    public static void raiseCliException(String message) throws CliException {
        Logger.notifyUser(message);
        throw new CliException(message, true);
    }

    public static void raiseCommandException(String message) throws CommandException {
        Logger.notifyUser(message);
        throw new CommandException(message);
    }

    public static void raisePrologException(List<String> errors, boolean onlyWarnings) throws PrologException {
        String message = "ProB reported " + (onlyWarnings ? "warnings:\n" : "errors:\n") + String.join((CharSequence)"\n", errors);
        Logger.notifyUser(message);
        if (!onlyWarnings) {
            throw new PrologException(message, onlyWarnings);
        }
    }

    public static void handleCommandException(String message, Throwable t) throws CommandException {
        Logger.notifyUser(message, t);
        throw new CommandException(message, t);
    }

    public static void handleCliException(String message, Throwable t) throws CliException {
        Logger.notifyUser(message, t);
        throw new CliException(message, t, true);
    }
}

