/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core;

import de.prob.core.IAnimationListener;
import de.prob.core.IComputationListener;
import de.prob.core.ILifecycleListener;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.logging.Logger;
import java.util.HashSet;
import java.util.Set;

public class ListenerRegistry
implements ILifecycleListener,
IComputationListener,
IAnimationListener {
    private final Set<ILifecycleListener> lifeCycleListeners = new HashSet<ILifecycleListener>();
    private final Set<IComputationListener> computationListeners = new HashSet<IComputationListener>();
    private final Set<IAnimationListener> animationListeners = new HashSet<IAnimationListener>();

    public void registerLifecycleListener(ILifecycleListener listener) {
        this.lifeCycleListeners.add(listener);
    }

    public void unregisterLifecycleListener(ILifecycleListener listener) {
        this.lifeCycleListeners.remove(listener);
    }

    public void registerComputationListener(IComputationListener listener) {
        this.computationListeners.add(listener);
    }

    public void unregisterComputationListener(IComputationListener listener) {
        this.computationListeners.remove(listener);
    }

    public void registerAnimationListener(IAnimationListener listener) {
        this.animationListeners.add(listener);
    }

    public void unregisterAnimationListener(IAnimationListener listener) {
        this.animationListeners.remove(listener);
    }

    @Override
    public void reset() {
        for (ILifecycleListener listener : this.lifeCycleListeners) {
            try {
                listener.reset();
            }
            catch (RuntimeException e) {
                String classname = listener.getClass().getCanonicalName();
                String message = "Runtime Exception thrown in bad behaving listener class " + classname + " while sending reset event";
                Logger.notifyUser(message, e);
            }
        }
    }

    @Override
    public void computedState(State state) {
        for (IComputationListener listener : this.computationListeners) {
            try {
                listener.computedState(state);
            }
            catch (RuntimeException e) {
                String classname = listener.getClass().getCanonicalName();
                String message = "Runtime Exception thrown in bad behaving listener class " + classname + " while sending computedState event";
                Logger.notifyUser(message, e);
            }
        }
    }

    @Override
    public void currentStateChanged(State currentState, Operation operation) {
        for (IAnimationListener listener : this.animationListeners) {
            try {
                listener.currentStateChanged(currentState, operation);
            }
            catch (RuntimeException e) {
                String classname = listener.getClass().getCanonicalName();
                String message = "Runtime Exception thrown in bad behaving listener class " + classname + " while sending currentStateChanged event";
                Logger.notifyUser(message, e);
            }
        }
    }
}

