/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.translator.internal;

import de.be4.classicalb.core.parser.node.AAddExpression;
import de.be4.classicalb.core.parser.node.AAssignSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesElementOfSubstitution;
import de.be4.classicalb.core.parser.node.ABecomesSuchSubstitution;
import de.be4.classicalb.core.parser.node.ABoolSetExpression;
import de.be4.classicalb.core.parser.node.ABooleanFalseExpression;
import de.be4.classicalb.core.parser.node.ABooleanTrueExpression;
import de.be4.classicalb.core.parser.node.ACardExpression;
import de.be4.classicalb.core.parser.node.ACartesianProductExpression;
import de.be4.classicalb.core.parser.node.ACompositionExpression;
import de.be4.classicalb.core.parser.node.AConjunctPredicate;
import de.be4.classicalb.core.parser.node.AConvertBoolExpression;
import de.be4.classicalb.core.parser.node.ACoupleExpression;
import de.be4.classicalb.core.parser.node.ADirectProductExpression;
import de.be4.classicalb.core.parser.node.ADisjunctPredicate;
import de.be4.classicalb.core.parser.node.ADivExpression;
import de.be4.classicalb.core.parser.node.ADomainExpression;
import de.be4.classicalb.core.parser.node.ADomainRestrictionExpression;
import de.be4.classicalb.core.parser.node.ADomainSubtractionExpression;
import de.be4.classicalb.core.parser.node.AEmptySetExpression;
import de.be4.classicalb.core.parser.node.AEqualPredicate;
import de.be4.classicalb.core.parser.node.AEquivalencePredicate;
import de.be4.classicalb.core.parser.node.AEventBComprehensionSetExpression;
import de.be4.classicalb.core.parser.node.AEventBFirstProjectionExpression;
import de.be4.classicalb.core.parser.node.AEventBFirstProjectionV2Expression;
import de.be4.classicalb.core.parser.node.AEventBIdentityExpression;
import de.be4.classicalb.core.parser.node.AEventBSecondProjectionExpression;
import de.be4.classicalb.core.parser.node.AEventBSecondProjectionV2Expression;
import de.be4.classicalb.core.parser.node.AExistsPredicate;
import de.be4.classicalb.core.parser.node.AExtendedExprExpression;
import de.be4.classicalb.core.parser.node.AExtendedPredPredicate;
import de.be4.classicalb.core.parser.node.AFalsityPredicate;
import de.be4.classicalb.core.parser.node.AFinitePredicate;
import de.be4.classicalb.core.parser.node.AForallPredicate;
import de.be4.classicalb.core.parser.node.AFunctionExpression;
import de.be4.classicalb.core.parser.node.AGeneralIntersectionExpression;
import de.be4.classicalb.core.parser.node.AGeneralUnionExpression;
import de.be4.classicalb.core.parser.node.AGreaterEqualPredicate;
import de.be4.classicalb.core.parser.node.AGreaterPredicate;
import de.be4.classicalb.core.parser.node.AIdentifierExpression;
import de.be4.classicalb.core.parser.node.AIdentityExpression;
import de.be4.classicalb.core.parser.node.AImageExpression;
import de.be4.classicalb.core.parser.node.AImplicationPredicate;
import de.be4.classicalb.core.parser.node.AIntegerExpression;
import de.be4.classicalb.core.parser.node.AIntegerSetExpression;
import de.be4.classicalb.core.parser.node.AIntersectionExpression;
import de.be4.classicalb.core.parser.node.AIntervalExpression;
import de.be4.classicalb.core.parser.node.ALessEqualPredicate;
import de.be4.classicalb.core.parser.node.ALessPredicate;
import de.be4.classicalb.core.parser.node.AMaxExpression;
import de.be4.classicalb.core.parser.node.AMemberPredicate;
import de.be4.classicalb.core.parser.node.AMinExpression;
import de.be4.classicalb.core.parser.node.AMinusExpression;
import de.be4.classicalb.core.parser.node.AModuloExpression;
import de.be4.classicalb.core.parser.node.AMultiplicationExpression;
import de.be4.classicalb.core.parser.node.ANatural1SetExpression;
import de.be4.classicalb.core.parser.node.ANaturalSetExpression;
import de.be4.classicalb.core.parser.node.ANegationPredicate;
import de.be4.classicalb.core.parser.node.ANotEqualPredicate;
import de.be4.classicalb.core.parser.node.ANotMemberPredicate;
import de.be4.classicalb.core.parser.node.ANotSubsetPredicate;
import de.be4.classicalb.core.parser.node.ANotSubsetStrictPredicate;
import de.be4.classicalb.core.parser.node.AOverwriteExpression;
import de.be4.classicalb.core.parser.node.AParallelProductExpression;
import de.be4.classicalb.core.parser.node.APartialFunctionExpression;
import de.be4.classicalb.core.parser.node.APartialInjectionExpression;
import de.be4.classicalb.core.parser.node.APartialSurjectionExpression;
import de.be4.classicalb.core.parser.node.APartitionPredicate;
import de.be4.classicalb.core.parser.node.APow1SubsetExpression;
import de.be4.classicalb.core.parser.node.APowSubsetExpression;
import de.be4.classicalb.core.parser.node.APowerOfExpression;
import de.be4.classicalb.core.parser.node.APredecessorExpression;
import de.be4.classicalb.core.parser.node.AQuantifiedIntersectionExpression;
import de.be4.classicalb.core.parser.node.AQuantifiedUnionExpression;
import de.be4.classicalb.core.parser.node.ARangeExpression;
import de.be4.classicalb.core.parser.node.ARangeRestrictionExpression;
import de.be4.classicalb.core.parser.node.ARangeSubtractionExpression;
import de.be4.classicalb.core.parser.node.ARelationsExpression;
import de.be4.classicalb.core.parser.node.AReverseExpression;
import de.be4.classicalb.core.parser.node.ARingExpression;
import de.be4.classicalb.core.parser.node.ASetExtensionExpression;
import de.be4.classicalb.core.parser.node.ASetSubtractionExpression;
import de.be4.classicalb.core.parser.node.ASubsetPredicate;
import de.be4.classicalb.core.parser.node.ASubsetStrictPredicate;
import de.be4.classicalb.core.parser.node.ASuccessorExpression;
import de.be4.classicalb.core.parser.node.ASurjectionRelationExpression;
import de.be4.classicalb.core.parser.node.ATotalBijectionExpression;
import de.be4.classicalb.core.parser.node.ATotalFunctionExpression;
import de.be4.classicalb.core.parser.node.ATotalInjectionExpression;
import de.be4.classicalb.core.parser.node.ATotalRelationExpression;
import de.be4.classicalb.core.parser.node.ATotalSurjectionExpression;
import de.be4.classicalb.core.parser.node.ATotalSurjectionRelationExpression;
import de.be4.classicalb.core.parser.node.ATruthPredicate;
import de.be4.classicalb.core.parser.node.ATypeofExpression;
import de.be4.classicalb.core.parser.node.AUnaryMinusExpression;
import de.be4.classicalb.core.parser.node.AUnionExpression;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.PSubstitution;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.be4.classicalb.core.parser.node.TIntegerLiteral;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.AssociativeExpression;
import org.eventb.core.ast.AssociativePredicate;
import org.eventb.core.ast.AtomicExpression;
import org.eventb.core.ast.BecomesEqualTo;
import org.eventb.core.ast.BecomesMemberOf;
import org.eventb.core.ast.BecomesSuchThat;
import org.eventb.core.ast.BinaryExpression;
import org.eventb.core.ast.BinaryPredicate;
import org.eventb.core.ast.BoolExpression;
import org.eventb.core.ast.BooleanType;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.ExtendedExpression;
import org.eventb.core.ast.ExtendedPredicate;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IntegerLiteral;
import org.eventb.core.ast.IntegerType;
import org.eventb.core.ast.LiteralPredicate;
import org.eventb.core.ast.MultiplePredicate;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.ProductType;
import org.eventb.core.ast.QuantifiedExpression;
import org.eventb.core.ast.QuantifiedPredicate;
import org.eventb.core.ast.RelationalPredicate;
import org.eventb.core.ast.SetExtension;
import org.eventb.core.ast.SimplePredicate;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.UnaryExpression;
import org.eventb.core.ast.UnaryPredicate;
import org.eventb.core.ast.extension.IExpressionExtension;

public class TranslationVisitor
implements ISimpleVisitor {
    private static final String UNCOVERED_PREDICATE = "Uncovered Predicate";
    private static final int[] EXTRA_TYPE_CONSTRUCTS = new int[]{407, 410, 411, 412};
    private final LookupStack<PPredicate> predicates = new LookupStack();
    private final LookupStack<PExpression> expressions = new LookupStack();
    private final LookupStack<PSubstitution> substitutions = new LookupStack();
    private final LookupStack<String> boundVariables = new LookupStack();

    public void visitAssociativeExpression(AssociativeExpression expression) {
        PExpression result;
        List<PExpression> exprs = this.getSubExpressions((Formula<?>[])expression.getChildren());
        switch (expression.getTag()) {
            case 301: {
                result = this.recurseBUNION(exprs);
                break;
            }
            case 302: {
                result = this.recurseBINTER(exprs);
                break;
            }
            case 303: {
                result = this.recurseBCOMP(exprs);
                break;
            }
            case 304: {
                result = this.recurseFCOMP(exprs);
                break;
            }
            case 305: {
                result = this.recurseOVR(exprs);
                break;
            }
            case 306: {
                result = this.recursePLUS(exprs);
                break;
            }
            case 307: {
                result = this.recurseMUL(exprs);
                break;
            }
            default: {
                throw new AssertionError((Object)UNCOVERED_PREDICATE);
            }
        }
        this.pushExpression((Expression)expression, result);
    }

    private void pushExpression(Expression original, PExpression translated) {
        Object toPush = original.getType() != null && this.shouldHaveExtraTypeInfo(original) ? new ATypeofExpression(translated, this.translateType(original.getType())) : translated;
        this.expressions.push((PExpression)toPush);
    }

    private boolean shouldHaveExtraTypeInfo(Expression original) {
        if (original instanceof ExtendedExpression) {
            return true;
        }
        int tag = original.getTag();
        int i = 0;
        while (i < EXTRA_TYPE_CONSTRUCTS.length) {
            if (EXTRA_TYPE_CONSTRUCTS[i] == tag) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private PExpression translateType(Type type) {
        ABoolSetExpression result;
        if (type instanceof BooleanType) {
            result = new ABoolSetExpression();
        } else if (type instanceof GivenType) {
            String name = ((GivenType)type).getName();
            result = this.createIdentifierExpression(name);
        } else if (type instanceof IntegerType) {
            result = new AIntegerSetExpression();
        } else if (type instanceof PowerSetType) {
            Type a = ((PowerSetType)type).getBaseType();
            result = new APowSubsetExpression(this.translateType(a));
        } else if (type instanceof ProductType) {
            Type a = ((ProductType)type).getLeft();
            Type b = ((ProductType)type).getRight();
            result = new ACartesianProductExpression(this.translateType(a), this.translateType(b));
        } else if (type instanceof ParametricType) {
            ParametricType pt = (ParametricType)type;
            IExpressionExtension ext = pt.getExprExtension();
            Type[] params = pt.getTypeParameters();
            ArrayList<PExpression> list = new ArrayList<PExpression>();
            Type[] typeArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Type param = typeArray[n2];
                list.add(this.translateType(param));
                ++n2;
            }
            result = new AExtendedExprExpression(new TIdentifierLiteral(ext.getSyntaxSymbol()), list, Collections.emptyList());
        } else {
            throw new AssertionError((Object)("Don't know how to handle the Event-B type of class " + type.getClass().getCanonicalName()));
        }
        return result;
    }

    private PExpression recurseFCOMP(List<PExpression> list) {
        PExpression right = list.size() == 2 ? list.get(1) : this.recurseFCOMP(list.subList(1, list.size()));
        return new ACompositionExpression(list.get(0), right);
    }

    private PExpression recurseOVR(List<PExpression> list) {
        PExpression right = list.size() == 2 ? list.get(1) : this.recurseOVR(list.subList(1, list.size()));
        return new AOverwriteExpression(list.get(0), right);
    }

    private PExpression recursePLUS(List<PExpression> list) {
        PExpression right = list.size() == 2 ? list.get(1) : this.recursePLUS(list.subList(1, list.size()));
        return new AAddExpression(list.get(0), right);
    }

    private PExpression recurseMUL(List<PExpression> list) {
        PExpression right = list.size() == 2 ? list.get(1) : this.recurseMUL(list.subList(1, list.size()));
        return new AMultiplicationExpression(list.get(0), right);
    }

    private PExpression recurseBUNION(List<PExpression> list) {
        PExpression right = list.size() == 2 ? list.get(1) : this.recurseBUNION(list.subList(1, list.size()));
        return new AUnionExpression(list.get(0), right);
    }

    private PExpression recurseBINTER(List<PExpression> list) {
        PExpression right = list.size() == 2 ? list.get(1) : this.recurseBINTER(list.subList(1, list.size()));
        return new AIntersectionExpression(list.get(0), right);
    }

    private PExpression recurseBCOMP(List<PExpression> list) {
        PExpression right = list.size() == 2 ? list.get(1) : this.recurseBCOMP(list.subList(1, list.size()));
        return new ARingExpression(list.get(0), right);
    }

    public void visitAssociativePredicate(AssociativePredicate predicate) {
        PPredicate result;
        List<PPredicate> children = this.getSubPredicates((Formula<?>[])predicate.getChildren());
        switch (predicate.getTag()) {
            case 352: {
                result = this.recurseOR(children);
                break;
            }
            case 351: {
                result = this.recurseAND(children);
                break;
            }
            case 252: {
                result = this.recurseEQV(children);
                break;
            }
            default: {
                throw new AssertionError((Object)UNCOVERED_PREDICATE);
            }
        }
        this.predicates.push(result);
    }

    private PPredicate recurseOR(List<PPredicate> list) {
        PPredicate left = list.size() == 2 ? list.get(0) : this.recurseOR(list.subList(0, list.size() - 1));
        return new ADisjunctPredicate(left, list.get(list.size() - 1));
    }

    private PPredicate recurseAND(List<PPredicate> list) {
        PPredicate left = list.size() == 2 ? list.get(0) : this.recurseAND(list.subList(0, list.size() - 1));
        return new AConjunctPredicate(left, list.get(list.size() - 1));
    }

    private PPredicate recurseEQV(List<PPredicate> list) {
        PPredicate left = list.size() == 2 ? list.get(0) : this.recurseEQV(list.subList(0, list.size() - 1));
        return new AEquivalencePredicate(left, list.get(list.size() - 1));
    }

    public void visitAtomicExpression(AtomicExpression expression) {
        AIntegerSetExpression result;
        switch (expression.getTag()) {
            case 401: {
                result = new AIntegerSetExpression();
                break;
            }
            case 402: {
                result = new ANaturalSetExpression();
                break;
            }
            case 403: {
                result = new ANatural1SetExpression();
                break;
            }
            case 404: {
                result = new ABoolSetExpression();
                break;
            }
            case 405: {
                result = new ABooleanTrueExpression();
                break;
            }
            case 406: {
                result = new ABooleanFalseExpression();
                break;
            }
            case 407: {
                result = new AEmptySetExpression();
                break;
            }
            case 408: {
                result = new APredecessorExpression();
                break;
            }
            case 409: {
                result = new ASuccessorExpression();
                break;
            }
            case 410: {
                result = new AEventBFirstProjectionV2Expression();
                break;
            }
            case 411: {
                result = new AEventBSecondProjectionV2Expression();
                break;
            }
            case 412: {
                result = new AEventBIdentityExpression();
                break;
            }
            default: {
                throw new AssertionError((Object)("Uncovered Expression " + String.valueOf(expression)));
            }
        }
        this.pushExpression((Expression)expression, (PExpression)result);
    }

    public void visitBecomesEqualTo(BecomesEqualTo assignment) {
        List<PExpression> lhs = this.getSubExpressions((Formula<?>[])assignment.getAssignedIdentifiers());
        List<PExpression> rhs = this.getSubExpressions((Formula<?>[])assignment.getExpressions());
        this.substitutions.push((PSubstitution)new AAssignSubstitution(lhs, rhs));
    }

    public void visitBecomesMemberOf(BecomesMemberOf assignment) {
        List<PExpression> lhs = this.getSubExpressions((Formula<?>[])assignment.getAssignedIdentifiers());
        PExpression set = this.getExpression(assignment.getSet());
        this.substitutions.push((PSubstitution)new ABecomesElementOfSubstitution(lhs, set));
    }

    public void visitBecomesSuchThat(BecomesSuchThat assignment) {
        List<PExpression> lhs = this.getSubExpressions((Formula<?>[])assignment.getAssignedIdentifiers());
        int originalBoundSize = this.boundVariables.size();
        FreeIdentifier[] freeIdentifierArray = assignment.getAssignedIdentifiers();
        int n = freeIdentifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            FreeIdentifier id = freeIdentifierArray[n2];
            this.boundVariables.push(id.getName() + "'");
            ++n2;
        }
        PPredicate predicate = this.getPredicate(assignment.getCondition());
        this.boundVariables.shrinkToSize(originalBoundSize);
        this.substitutions.push((PSubstitution)new ABecomesSuchSubstitution(lhs, predicate));
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        ARelationsExpression result;
        PExpression exL = this.getExpression(expression.getLeft());
        PExpression exR = this.getExpression(expression.getRight());
        switch (expression.getTag()) {
            case 201: {
                result = new ACoupleExpression(Arrays.asList(exL, exR));
                break;
            }
            case 202: {
                result = new ARelationsExpression(exL, exR);
                break;
            }
            case 203: {
                result = new ATotalRelationExpression(exL, exR);
                break;
            }
            case 204: {
                result = new ASurjectionRelationExpression(exL, exR);
                break;
            }
            case 205: {
                result = new ATotalSurjectionRelationExpression(exL, exR);
                break;
            }
            case 206: {
                result = new APartialFunctionExpression(exL, exR);
                break;
            }
            case 207: {
                result = new ATotalFunctionExpression(exL, exR);
                break;
            }
            case 208: {
                result = new APartialInjectionExpression(exL, exR);
                break;
            }
            case 209: {
                result = new ATotalInjectionExpression(exL, exR);
                break;
            }
            case 210: {
                result = new APartialSurjectionExpression(exL, exR);
                break;
            }
            case 211: {
                result = new ATotalSurjectionExpression(exL, exR);
                break;
            }
            case 212: {
                result = new ATotalBijectionExpression(exL, exR);
                break;
            }
            case 213: {
                result = new ASetSubtractionExpression(exL, exR);
                break;
            }
            case 214: {
                result = new ACartesianProductExpression(exL, exR);
                break;
            }
            case 215: {
                result = new ADirectProductExpression(exL, exR);
                break;
            }
            case 216: {
                result = new AParallelProductExpression(exL, exR);
                break;
            }
            case 217: {
                result = new ADomainRestrictionExpression(exL, exR);
                break;
            }
            case 218: {
                result = new ADomainSubtractionExpression(exL, exR);
                break;
            }
            case 219: {
                result = new ARangeRestrictionExpression(exL, exR);
                break;
            }
            case 220: {
                result = new ARangeSubtractionExpression(exL, exR);
                break;
            }
            case 221: {
                result = new AIntervalExpression(exL, exR);
                break;
            }
            case 222: {
                result = new AMinusExpression(exL, exR);
                break;
            }
            case 223: {
                result = new ADivExpression(exL, exR);
                break;
            }
            case 224: {
                result = new AModuloExpression(exL, exR);
                break;
            }
            case 225: {
                result = new APowerOfExpression(exL, exR);
                break;
            }
            case 226: {
                result = new AFunctionExpression(exL, Arrays.asList(exR));
                break;
            }
            case 227: {
                result = new AImageExpression(exL, exR);
                break;
            }
            default: {
                throw new AssertionError((Object)"Uncovered Expression");
            }
        }
        this.pushExpression((Expression)expression, (PExpression)result);
    }

    public void visitBinaryPredicate(BinaryPredicate predicate) {
        AImplicationPredicate result;
        PPredicate left = this.getPredicate(predicate.getLeft());
        PPredicate right = this.getPredicate(predicate.getRight());
        switch (predicate.getTag()) {
            case 251: {
                result = new AImplicationPredicate(left, right);
                break;
            }
            case 252: {
                result = new AEquivalencePredicate(left, right);
                break;
            }
            default: {
                throw new AssertionError((Object)UNCOVERED_PREDICATE);
            }
        }
        this.predicates.push((PPredicate)result);
    }

    public void visitBoolExpression(BoolExpression expression) {
        PPredicate pred = this.getPredicate(expression.getPredicate());
        this.pushExpression((Expression)expression, (PExpression)new AConvertBoolExpression(pred));
    }

    public void visitBoundIdentDecl(BoundIdentDecl boundIdentDecl) {
        String name = boundIdentDecl.getName();
        this.boundVariables.push(name);
        this.expressions.push((PExpression)this.createIdentifierExpression(name));
    }

    private AIdentifierExpression createIdentifierExpression(String name) {
        return new AIdentifierExpression(Arrays.asList(new TIdentifierLiteral(name)));
    }

    public void visitBoundIdentifier(BoundIdentifier identifierExpression) {
        String name = this.boundVariables.get(identifierExpression.getBoundIndex());
        this.pushExpression((Expression)identifierExpression, (PExpression)this.createIdentifierExpression(name));
    }

    public void visitFreeIdentifier(FreeIdentifier identifierExpression) {
        this.pushExpression((Expression)identifierExpression, (PExpression)this.createIdentifierExpression(identifierExpression.getName()));
    }

    public void visitIntegerLiteral(IntegerLiteral expression) {
        BigInteger value = expression.getValue();
        AUnaryMinusExpression intExpr = value.signum() == -1 ? new AUnaryMinusExpression((PExpression)new AIntegerExpression(new TIntegerLiteral(value.abs().toString()))) : new AIntegerExpression(new TIntegerLiteral(value.toString()));
        this.pushExpression((Expression)expression, (PExpression)intExpr);
    }

    public void visitLiteralPredicate(LiteralPredicate predicate) {
        ATruthPredicate result;
        switch (predicate.getTag()) {
            case 610: {
                result = new ATruthPredicate();
                break;
            }
            case 611: {
                result = new AFalsityPredicate();
                break;
            }
            default: {
                throw new AssertionError((Object)UNCOVERED_PREDICATE);
            }
        }
        this.predicates.push((PPredicate)result);
    }

    public void visitQuantifiedExpression(QuantifiedExpression expression) {
        AQuantifiedUnionExpression result;
        int originalBoundSize = this.boundVariables.size();
        BoundIdentDecl[] decls = expression.getBoundIdentDecls();
        List<PExpression> list = this.getSubExpressions((Formula<?>[])decls);
        PPredicate pr = this.getPredicate(expression.getPredicate());
        PExpression ex = this.getExpression(expression.getExpression());
        this.boundVariables.shrinkToSize(originalBoundSize);
        PPredicate pred = this.addTypesToPredicate(pr, decls);
        switch (expression.getTag()) {
            case 801: {
                result = new AQuantifiedUnionExpression(list, pred, ex);
                break;
            }
            case 802: {
                result = new AQuantifiedIntersectionExpression(list, pred, ex);
                break;
            }
            case 803: {
                result = new AEventBComprehensionSetExpression(list, ex, pred);
                break;
            }
            default: {
                throw new AssertionError((Object)UNCOVERED_PREDICATE);
            }
        }
        this.pushExpression((Expression)expression, (PExpression)result);
    }

    public void visitQuantifiedPredicate(QuantifiedPredicate predicate) {
        AExistsPredicate result;
        int originalBoundSize = this.boundVariables.size();
        BoundIdentDecl[] decls = predicate.getBoundIdentDecls();
        List<PExpression> list = this.getSubExpressions((Formula<?>[])decls);
        PPredicate pred = this.getPredicate(predicate.getPredicate());
        this.boundVariables.shrinkToSize(originalBoundSize);
        switch (predicate.getTag()) {
            case 852: {
                result = new AExistsPredicate(list, this.addTypesToPredicate(pred, decls));
                break;
            }
            case 851: {
                PPredicate right;
                PPredicate left;
                if (pred instanceof AImplicationPredicate) {
                    AImplicationPredicate i = (AImplicationPredicate)pred;
                    left = this.addTypesToPredicate(i.getLeft(), decls);
                    right = i.getRight();
                } else {
                    left = this.addTypesToPredicate(null, decls);
                    right = pred;
                }
                AImplicationPredicate impl = new AImplicationPredicate((PPredicate)(left != null ? left : new ATruthPredicate()), right);
                result = new AForallPredicate(list, (PPredicate)impl);
                break;
            }
            default: {
                throw new AssertionError((Object)UNCOVERED_PREDICATE);
            }
        }
        this.predicates.push((PPredicate)result);
    }

    private PPredicate addTypesToPredicate(PPredicate predicate, BoundIdentDecl[] decls) {
        int i = decls.length;
        while (i > 0) {
            BoundIdentDecl decl = decls[i - 1];
            Type type = decl.getType();
            if (type != null) {
                AIdentifierExpression expr = this.createIdentifierExpression(decl.getName());
                AMemberPredicate member = new AMemberPredicate((PExpression)expr, this.translateType(type));
                predicate = predicate == null ? member : new AConjunctPredicate((PPredicate)member, predicate);
            }
            --i;
        }
        return predicate;
    }

    public void visitRelationalPredicate(RelationalPredicate predicate) {
        AEqualPredicate result;
        PExpression left = this.getExpression(predicate.getLeft());
        PExpression right = this.getExpression(predicate.getRight());
        switch (predicate.getTag()) {
            case 101: {
                result = new AEqualPredicate(left, right);
                break;
            }
            case 102: {
                result = new ANotEqualPredicate(left, right);
                break;
            }
            case 103: {
                result = new ALessPredicate(left, right);
                break;
            }
            case 104: {
                result = new ALessEqualPredicate(left, right);
                break;
            }
            case 105: {
                result = new AGreaterPredicate(left, right);
                break;
            }
            case 106: {
                result = new AGreaterEqualPredicate(left, right);
                break;
            }
            case 107: {
                result = new AMemberPredicate(left, right);
                break;
            }
            case 108: {
                result = new ANotMemberPredicate(left, right);
                break;
            }
            case 109: {
                result = new ASubsetStrictPredicate(left, right);
                break;
            }
            case 110: {
                result = new ANotSubsetStrictPredicate(left, right);
                break;
            }
            case 111: {
                result = new ASubsetPredicate(left, right);
                break;
            }
            case 112: {
                result = new ANotSubsetPredicate(left, right);
                break;
            }
            default: {
                throw new AssertionError((Object)UNCOVERED_PREDICATE);
            }
        }
        this.predicates.push((PPredicate)result);
    }

    public void visitSetExtension(SetExtension expression) {
        Expression[] members = expression.getMembers();
        List<PExpression> list = this.getSubExpressions((Formula<?>[])members);
        this.pushExpression((Expression)expression, (PExpression)new ASetExtensionExpression(list));
    }

    public void visitSimplePredicate(SimplePredicate predicate) {
        if (predicate.getTag() != 620) {
            throw new AssertionError((Object)UNCOVERED_PREDICATE);
        }
        AFinitePredicate result = new AFinitePredicate(this.getExpression(predicate.getExpression()));
        this.predicates.push((PPredicate)result);
    }

    public void visitUnaryExpression(UnaryExpression expression) {
        ACardExpression result;
        PExpression exp = this.getExpression(expression.getChild());
        switch (expression.getTag()) {
            case 751: {
                result = new ACardExpression(exp);
                break;
            }
            case 752: {
                result = new APowSubsetExpression(exp);
                break;
            }
            case 753: {
                result = new APow1SubsetExpression(exp);
                break;
            }
            case 754: {
                result = new AGeneralUnionExpression(exp);
                break;
            }
            case 755: {
                result = new AGeneralIntersectionExpression(exp);
                break;
            }
            case 756: {
                result = new ADomainExpression(exp);
                break;
            }
            case 757: {
                result = new ARangeExpression(exp);
                break;
            }
            case 758: {
                result = new AEventBFirstProjectionExpression(exp);
                break;
            }
            case 759: {
                result = new AEventBSecondProjectionExpression(exp);
                break;
            }
            case 760: {
                result = new AIdentityExpression(exp);
                break;
            }
            case 761: {
                result = new AMinExpression(exp);
                break;
            }
            case 762: {
                result = new AMaxExpression(exp);
                break;
            }
            case 763: {
                result = new AReverseExpression(exp);
                break;
            }
            case 764: {
                result = new AUnaryMinusExpression(exp);
                break;
            }
            default: {
                throw new AssertionError((Object)"Uncovered Expression");
            }
        }
        this.pushExpression((Expression)expression, (PExpression)result);
    }

    public void visitUnaryPredicate(UnaryPredicate predicate) {
        if (predicate.getTag() != 701) {
            throw new AssertionError((Object)UNCOVERED_PREDICATE);
        }
        ANegationPredicate result = new ANegationPredicate(this.getPredicate(predicate.getChild()));
        this.predicates.push((PPredicate)result);
    }

    public void visitMultiplePredicate(MultiplePredicate predicate) {
        List<PExpression> expressions;
        if (predicate.getTag() == 901) {
            expressions = this.getSubExpressions((Formula<?>[])predicate.getChildren());
            if (expressions.size() <= 0) {
                throw new AssertionError((Object)"to few arguments for PARTITION");
            }
        } else {
            throw new AssertionError((Object)UNCOVERED_PREDICATE);
        }
        PExpression set = expressions.remove(0);
        APartitionPredicate result = new APartitionPredicate(set, expressions);
        this.predicates.push((PPredicate)result);
    }

    public void visitExtendedExpression(ExtendedExpression expression) {
        String symbol = expression.getExtension().getSyntaxSymbol();
        List<PExpression> childExprs = this.getSubExpressions((Formula<?>[])expression.getChildExpressions());
        List<PPredicate> childPreds = this.getSubPredicates((Formula<?>[])expression.getChildPredicates());
        this.pushExpression((Expression)expression, (PExpression)new AExtendedExprExpression(new TIdentifierLiteral(symbol), childExprs, childPreds));
    }

    public void visitExtendedPredicate(ExtendedPredicate predicate) {
        String symbol = predicate.getExtension().getSyntaxSymbol();
        List<PExpression> childExprs = this.getSubExpressions((Formula<?>[])predicate.getChildExpressions());
        List<PPredicate> childPreds = this.getSubPredicates((Formula<?>[])predicate.getChildPredicates());
        this.predicates.push((PPredicate)new AExtendedPredPredicate(new TIdentifierLiteral(symbol), childExprs, childPreds));
    }

    private List<PExpression> getSubExpressions(Formula<?>[] children) {
        Formula<?>[] formulaArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Formula<?> f = formulaArray[n2];
            f.accept((ISimpleVisitor)this);
            ++n2;
        }
        return this.expressions.removeLastElements(children.length);
    }

    private List<PPredicate> getSubPredicates(Formula<?>[] children) {
        Formula<?>[] formulaArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Formula<?> f = formulaArray[n2];
            f.accept((ISimpleVisitor)this);
            ++n2;
        }
        return this.predicates.removeLastElements(children.length);
    }

    private PPredicate getPredicate(Predicate predicate) {
        predicate.accept((ISimpleVisitor)this);
        return this.predicates.pop();
    }

    private PExpression getExpression(Expression expression) {
        expression.accept((ISimpleVisitor)this);
        return this.expressions.pop();
    }

    public PPredicate getPredicate() {
        this.assertExactStacksize(this.predicates);
        return this.predicates.pop();
    }

    public PExpression getExpression() {
        this.assertExactStacksize(this.expressions);
        return this.expressions.pop();
    }

    public PSubstitution getSubstitution() {
        this.assertExactStacksize(this.substitutions);
        return this.substitutions.pop();
    }

    private void assertExactStacksize(LookupStack<?> stack) {
        if (stack.size() != 1) {
            throw new AssertionError((Object)("Exactly one element on the stack expected, but were " + this.predicates.size()));
        }
    }

    public static PPredicate translatePredicate(Predicate p) {
        TranslationVisitor visitor = new TranslationVisitor();
        p.accept((ISimpleVisitor)visitor);
        return visitor.getPredicate();
    }

    public static PExpression translateExpression(Expression e) {
        TranslationVisitor visitor = new TranslationVisitor();
        e.accept((ISimpleVisitor)visitor);
        return visitor.getExpression();
    }

    public static PSubstitution translateAssignment(Assignment a) {
        TranslationVisitor visitor = new TranslationVisitor();
        a.accept((ISimpleVisitor)visitor);
        return visitor.getSubstitution();
    }

    private static class LookupStack<T> {
        private final List<T> elements = new ArrayList<T>();

        private LookupStack() {
        }

        public void push(T elem) {
            this.elements.add(elem);
        }

        public T pop() {
            return this.elements.remove(this.elements.size() - 1);
        }

        public int size() {
            return this.elements.size();
        }

        public T get(int pos) {
            return this.elements.get(this.elements.size() - pos - 1);
        }

        void shrinkToSize(int size) {
            int oSize = this.elements.size();
            int rSize = oSize - size;
            int i = 0;
            while (i < rSize) {
                this.elements.remove(oSize - 1 - i);
                ++i;
            }
        }

        List<T> removeLastElements(int toRemove) {
            int targetSize = this.elements.size() - toRemove;
            ArrayList<T> result = new ArrayList<T>(toRemove);
            int i = 0;
            while (i < toRemove) {
                result.add(this.elements.get(targetSize + i));
                ++i;
            }
            this.shrinkToSize(targetSize);
            return result;
        }

        public String toString() {
            return this.elements.toString();
        }
    }
}

