/*
 * Decompiled with CFR 0.152.
 */
package de.prob.eventb.translator.internal;

import de.be4.classicalb.core.parser.analysis.prolog.PositionPrinter;
import de.be4.classicalb.core.parser.node.Node;
import de.prob.core.translator.TranslationFailedException;
import de.prob.prolog.output.IPrologTermOutput;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eventb.core.ILabeledElement;
import org.eventb.core.ITraceableElement;
import org.rodinp.core.IInternalElement;
import org.rodinp.core.IRodinElement;
import org.rodinp.core.RodinDBException;

public class LabelPositionPrinter
implements PositionPrinter {
    private IPrologTermOutput pout;
    private final Map<Node, NodeInfo> nodeInfos = new ConcurrentHashMap<Node, NodeInfo>();

    public void addNode(Node node, IInternalElement element, String file) throws TranslationFailedException {
        try {
            String source;
            if (element instanceof ITraceableElement) {
                IRodinElement traceableSource = ((ITraceableElement)element).getSource();
                source = traceableSource.getElementName();
            } else {
                source = null;
            }
            String label = element instanceof ILabeledElement ? ((ILabeledElement)element).getLabel() : null;
            this.addNode(node, label, source, file);
        }
        catch (RodinDBException e) {
            throw new TranslationFailedException(element.getElementName(), "A Rodin exception occured during translation process, you can try to fix that by cleaning the project. Original Exception: " + e.getLocalizedMessage());
        }
    }

    public void addNodes(Map<Node, IInternalElement> nodeMapping, String name) throws TranslationFailedException {
        for (Map.Entry<Node, IInternalElement> item : nodeMapping.entrySet()) {
            Node key = item.getKey();
            IInternalElement value = item.getValue();
            this.addNode(key, value, name);
        }
    }

    private void addNode(Node node, String label, String elementName, String file) {
        if (label != null || elementName != null) {
            this.nodeInfos.put(node, new NodeInfo(label, elementName, file));
        }
    }

    public void printPosition(Node node) {
        NodeInfo info = this.nodeInfos.get(node);
        if (info == null) {
            this.pout.printAtom("none");
        } else {
            this.pout.openTerm("rodinpos");
            if (info.file == null) {
                this.pout.emptyList();
            } else {
                this.pout.printAtom(info.file);
            }
            if (info.label == null) {
                this.pout.emptyList();
            } else {
                this.pout.printAtom(info.label);
            }
            if (info.elementName == null) {
                this.pout.emptyList();
            } else {
                this.pout.printAtom(info.elementName);
            }
            this.pout.closeTerm();
        }
    }

    public void setPrologTermOutput(IPrologTermOutput pout) {
        this.pout = pout;
    }

    private static class NodeInfo {
        private final String label;
        private final String elementName;
        private final String file;

        public NodeInfo(String label, String elementName, String file) {
            this.label = label;
            this.elementName = elementName;
            this.file = file;
        }
    }
}

