/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.internal;

import de.prob.core.IComputationListener;
import de.prob.core.domainobjects.State;
import de.prob.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ComputationListenerProxy
implements IComputationListener {
    private final IConfigurationElement config;
    private IComputationListener instance;

    public ComputationListenerProxy(IConfigurationElement config) {
        this.config = config;
    }

    @Override
    public void computedState(State state) {
        if (this.instance == null) {
            this.instance = this.init();
        }
        if (this.instance != null) {
            this.instance.computedState(state);
        }
    }

    private IComputationListener init() {
        try {
            return (IComputationListener)this.config.createExecutableExtension("class");
        }
        catch (CoreException e) {
            Logger.notifyUser("A Listener could not be instatiated. Class is: " + this.config.getAttribute("class"), e);
            e.printStackTrace();
            return null;
        }
    }
}

