/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.command.LtlCheckingCommand;
import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleBinaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleDisjunction;
import de.prob.core.domainobjects.ltl.CounterExampleGlobally;
import de.prob.core.domainobjects.ltl.CounterExampleNegation;
import de.prob.core.domainobjects.ltl.CounterExamplePredicate;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleRelease;
import de.prob.core.domainobjects.ltl.CounterExampleUntil;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CounterExampleWeakUntil
extends CounterExampleBinaryOperator {
    public CounterExampleWeakUntil(CounterExample counterExample, CounterExampleProposition firstArgument, CounterExampleProposition secondArgument) {
        super("W", "Weak Until", counterExample, firstArgument, secondArgument);
        this.checkByRelease(counterExample, firstArgument, secondArgument);
        this.checkByUntil(counterExample, firstArgument, secondArgument);
    }

    private void checkByUntil(CounterExample counterExample, CounterExampleProposition firstArgument, CounterExampleProposition secondArgument) {
        CounterExampleNegation not = new CounterExampleNegation(counterExample, firstArgument);
        CounterExampleValueType[] trueValues = new CounterExampleValueType[firstArgument.getValues().size()];
        Arrays.fill((Object[])trueValues, (Object)CounterExampleValueType.TRUE);
        CounterExamplePredicate truePredicate = new CounterExamplePredicate("", counterExample, Arrays.asList(trueValues));
        CounterExampleNegation notUntil = new CounterExampleNegation(counterExample, new CounterExampleUntil(counterExample, truePredicate, not));
        CounterExampleUntil until = new CounterExampleUntil(counterExample, firstArgument, secondArgument);
        this.addCheck(new CounterExampleDisjunction(counterExample, notUntil, until));
        this.addCheck(new CounterExampleDisjunction(counterExample, until, new CounterExampleGlobally(counterExample, firstArgument)));
    }

    private void checkByRelease(CounterExample counterExample, CounterExampleProposition firstArgument, CounterExampleProposition secondArgument) {
        this.addCheck(new CounterExampleRelease(counterExample, secondArgument, new CounterExampleDisjunction(counterExample, secondArgument, firstArgument)));
    }

    @Override
    protected CounterExampleValueType calculate(int position) {
        return this.calculateWeakUntilOperator(position);
    }

    private CounterExampleValueType calculateWeakUntilOperator(int position) {
        int unknownStateIndex;
        CounterExampleValueType result = CounterExampleValueType.UNKNOWN;
        List<CounterExampleValueType> firstCheckedValues = new ArrayList<CounterExampleValueType>(this.getFirstArgument().getValues());
        List<CounterExampleValueType> secondCheckedValues = new ArrayList<CounterExampleValueType>(this.getSecondArgument().getValues());
        if (this.pathType == LtlCheckingCommand.PathType.INFINITE && position > this.loopEntry) {
            firstCheckedValues.addAll(firstCheckedValues.subList(this.loopEntry, position));
            secondCheckedValues.addAll(secondCheckedValues.subList(this.loopEntry, position));
        }
        firstCheckedValues = firstCheckedValues.subList(position, firstCheckedValues.size());
        secondCheckedValues = secondCheckedValues.subList(position, secondCheckedValues.size());
        int firstIndex = -1;
        boolean trueOrUnknown = false;
        int secondIndex = secondCheckedValues.indexOf((Object)CounterExampleValueType.TRUE);
        if (secondIndex != -1) {
            firstIndex = firstCheckedValues.subList(0, secondIndex).indexOf((Object)CounterExampleValueType.FALSE);
            if (firstIndex == -1) {
                trueOrUnknown = true;
                unknownStateIndex = this.indexOfUnknownState(firstCheckedValues = firstCheckedValues.subList(0, secondIndex + 1), secondCheckedValues = secondCheckedValues.subList(0, secondIndex + 1), false);
                if (unknownStateIndex != -1) {
                    firstCheckedValues = firstCheckedValues.subList(0, unknownStateIndex + 1);
                    secondCheckedValues = secondCheckedValues.subList(0, unknownStateIndex + 1);
                    secondIndex = -1;
                } else if (!(firstCheckedValues = firstCheckedValues.subList(0, secondIndex)).contains((Object)CounterExampleValueType.UNKNOWN)) {
                    result = CounterExampleValueType.TRUE;
                } else {
                    secondIndex = -1;
                }
            }
        } else if (this.pathType != LtlCheckingCommand.PathType.REDUCED && !firstCheckedValues.contains((Object)CounterExampleValueType.FALSE)) {
            trueOrUnknown = true;
            result = CounterExampleValueType.TRUE;
            secondCheckedValues.clear();
        }
        if (!trueOrUnknown) {
            firstIndex = firstCheckedValues.indexOf((Object)CounterExampleValueType.FALSE);
            if (firstIndex != -1) {
                secondCheckedValues = secondCheckedValues.subList(0, firstIndex + 1);
                secondIndex = -1;
                if (!secondCheckedValues.contains((Object)CounterExampleValueType.UNKNOWN)) {
                    result = CounterExampleValueType.FALSE;
                } else {
                    firstCheckedValues = firstCheckedValues.subList(0, firstIndex + 1);
                    firstIndex = -1;
                    unknownStateIndex = this.indexOfUnknownState(firstCheckedValues, secondCheckedValues, false);
                    if (unknownStateIndex != -1) {
                        firstCheckedValues = firstCheckedValues.subList(0, unknownStateIndex + 1);
                        secondCheckedValues = secondCheckedValues.subList(0, unknownStateIndex + 1);
                    }
                }
            } else {
                unknownStateIndex = this.indexOfUnknownState(firstCheckedValues, secondCheckedValues, false);
                if (unknownStateIndex != -1) {
                    firstCheckedValues = firstCheckedValues.subList(0, unknownStateIndex + 1);
                    secondCheckedValues = secondCheckedValues.subList(0, unknownStateIndex + 1);
                }
            }
        }
        this.fillHighlightedPositions(position, firstIndex, secondIndex, firstCheckedValues.size(), secondCheckedValues.size(), false);
        return result;
    }
}

