/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.ltl;

import de.prob.core.domainobjects.ltl.CounterExample;
import de.prob.core.domainobjects.ltl.CounterExampleBinaryOperator;
import de.prob.core.domainobjects.ltl.CounterExampleDisjunction;
import de.prob.core.domainobjects.ltl.CounterExampleNegation;
import de.prob.core.domainobjects.ltl.CounterExampleProposition;
import de.prob.core.domainobjects.ltl.CounterExampleValueType;

public final class CounterExampleConjunction
extends CounterExampleBinaryOperator {
    public CounterExampleConjunction(CounterExample counterExample, CounterExampleProposition firstArgument, CounterExampleProposition secondArgument) {
        super("and", "Conjunction", counterExample, firstArgument, secondArgument);
        this.addCheckByDeMorgan(counterExample, firstArgument, secondArgument);
    }

    private void addCheckByDeMorgan(CounterExample counterExample, CounterExampleProposition firstArgument, CounterExampleProposition secondArgument) {
        CounterExampleNegation notFirstArgument = new CounterExampleNegation(counterExample, firstArgument);
        CounterExampleNegation notSecondArgument = new CounterExampleNegation(counterExample, secondArgument);
        CounterExampleDisjunction or = new CounterExampleDisjunction(counterExample, notFirstArgument, notSecondArgument);
        this.addCheck(new CounterExampleNegation(counterExample, or));
    }

    @Override
    protected CounterExampleValueType calculate(int position) {
        CounterExampleValueType firstValue = this.getFirstArgument().getValues().get(position);
        CounterExampleValueType secondValue = this.getSecondArgument().getValues().get(position);
        int firstCheckedSize = 1;
        int secondCheckedSize = 1;
        if (firstValue == CounterExampleValueType.FALSE) {
            secondCheckedSize = 0;
        } else if (secondValue == CounterExampleValueType.FALSE) {
            firstCheckedSize = 0;
        }
        this.fillHighlightedPositions(position, -1, -1, firstCheckedSize, secondCheckedSize, false);
        CounterExampleValueType value = CounterExampleConjunction.calculateAnd(firstValue, secondValue);
        return value;
    }

    public static CounterExampleValueType calculateAnd(CounterExampleValueType firstValue, CounterExampleValueType secondValue) {
        CounterExampleValueType result = CounterExampleValueType.TRUE;
        if (firstValue == CounterExampleValueType.FALSE || secondValue == CounterExampleValueType.FALSE) {
            result = CounterExampleValueType.FALSE;
        } else if (firstValue == CounterExampleValueType.UNKNOWN || secondValue == CounterExampleValueType.UNKNOWN) {
            result = CounterExampleValueType.UNKNOWN;
        }
        return result;
    }
}

