/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects.eval;

import de.be4.classicalb.core.parser.exceptions.BCompoundException;
import de.be4.classicalb.core.parser.exceptions.BException;
import de.be4.classicalb.core.parser.node.AExpressionParseUnit;
import de.be4.classicalb.core.parser.node.EOF;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PParseUnit;
import de.be4.classicalb.core.parser.node.Start;
import de.prob.core.domainobjects.eval.AbstractEvalElement;
import de.prob.eventb.translator.internal.TranslationVisitor;
import org.eventb.core.ast.Expression;

public final class ExpressionEvalElement
extends AbstractEvalElement {
    private final Start parse;
    private final String expression;

    public static ExpressionEvalElement fromRodin(Expression expression) throws BCompoundException {
        if (expression == null) {
            String message = "Expression input must not be null";
            throw new BCompoundException(new BException("", message, (Throwable)new NullPointerException(message)));
        }
        PExpression expr = TranslationVisitor.translateExpression(expression);
        AExpressionParseUnit epu = new AExpressionParseUnit(expr);
        Start start = new Start((PParseUnit)epu, new EOF());
        return new ExpressionEvalElement(expression, start);
    }

    public static ExpressionEvalElement create(String expression) throws BCompoundException {
        return new ExpressionEvalElement(expression);
    }

    public ExpressionEvalElement(String expression) throws BCompoundException {
        this.expression = expression;
        this.parse = this.parse("#EXPRESSION", expression);
    }

    public ExpressionEvalElement(Expression expression, Start start) {
        this.expression = expression.toString();
        this.parse = start;
    }

    @Override
    public Start getPrologAst() {
        return this.parse;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public String getLabel() {
        return this.expression;
    }
}

