/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects;

import de.prob.core.command.GetMachineObjectsCommand;
import de.prob.core.types.TypedIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MachineDescription {
    private final List<Section> sections;
    private final List<Section> nonEmptySections;
    private final Collection<String> identifiers;
    private final Map<String, List<String>> sectionIdentifiers;
    private final Map<String, String> sectionOfIdentifier;
    private final Map<String, Collection<String>> allSectionsOfIdentifier;
    private final Map<String, TypedIdentifier> types;
    private final Collection<String> eventNames;

    public MachineDescription(GetMachineObjectsCommand.MachineObjectsResult mor) {
        int clen = mor.constants.length;
        int vlen = mor.variables.length;
        TypedIdentifier[] typedIdentifiers = new TypedIdentifier[clen + vlen];
        System.arraycopy(mor.constants, 0, typedIdentifiers, 0, clen);
        System.arraycopy(mor.variables, 0, typedIdentifiers, clen, vlen);
        this.sections = Collections.unmodifiableList(Arrays.asList(mor.sections));
        HashMap<String, List<String>> secIds = new HashMap<String, List<String>>();
        ArrayList<String> ids = new ArrayList<String>(typedIdentifiers.length);
        HashMap<String, String> secOfId = new HashMap<String, String>();
        this.allSectionsOfIdentifier = new HashMap<String, Collection<String>>();
        MachineDescription.classifyIdentifiers(typedIdentifiers, secIds, ids, secOfId, this.allSectionsOfIdentifier);
        this.identifiers = Collections.unmodifiableCollection(ids);
        this.sectionIdentifiers = Collections.unmodifiableMap(secIds);
        this.sectionOfIdentifier = Collections.unmodifiableMap(secOfId);
        this.eventNames = MachineDescription.extractEvents(mor);
        this.nonEmptySections = MachineDescription.filterNonEmpty(this.sections, this.sectionIdentifiers);
        this.types = this.createTypeMap(typedIdentifiers);
    }

    private Map<String, TypedIdentifier> createTypeMap(TypedIdentifier[] typedIdentifiers) {
        HashMap<String, TypedIdentifier> typeMap = new HashMap<String, TypedIdentifier>();
        TypedIdentifier[] typedIdentifierArray = typedIdentifiers;
        int n = typedIdentifiers.length;
        int n2 = 0;
        while (n2 < n) {
            TypedIdentifier ti = typedIdentifierArray[n2];
            typeMap.put(ti.getName(), ti);
            ++n2;
        }
        return Collections.unmodifiableMap(typeMap);
    }

    private static void classifyIdentifiers(TypedIdentifier[] typedIdentifiers, Map<String, List<String>> secIds, ArrayList<String> ids, Map<String, String> secOfId, Map<String, Collection<String>> allSecsOfId) {
        TypedIdentifier[] typedIdentifierArray = typedIdentifiers;
        int n = typedIdentifiers.length;
        int n2 = 0;
        while (n2 < n) {
            TypedIdentifier tid = typedIdentifierArray[n2];
            String name = tid.getName();
            ids.add(name);
            boolean first = true;
            Collection<String> allSections = tid.getSections();
            allSecsOfId.put(name, allSections);
            for (String sec : allSections) {
                List<String> idsOfSection;
                if (first) {
                    secOfId.put(name, sec);
                    first = false;
                }
                if ((idsOfSection = secIds.get(sec)) == null) {
                    idsOfSection = new ArrayList<String>();
                    secIds.put(sec, idsOfSection);
                }
                idsOfSection.add(name);
            }
            ++n2;
        }
    }

    private static Collection<String> extractEvents(GetMachineObjectsCommand.MachineObjectsResult mor) {
        ArrayList<String> events = new ArrayList<String>();
        TypedIdentifier[] typedIdentifierArray = mor.operations;
        int n = mor.operations.length;
        int n2 = 0;
        while (n2 < n) {
            TypedIdentifier tevent = typedIdentifierArray[n2];
            events.add(tevent.getName());
            ++n2;
        }
        return Collections.unmodifiableCollection(events);
    }

    private static List<Section> filterNonEmpty(List<Section> sections, Map<String, List<String>> vars) {
        ArrayList<Section> nonEmpty = new ArrayList<Section>(sections);
        Iterator it = nonEmpty.iterator();
        while (it.hasNext()) {
            Section sec = (Section)it.next();
            List<String> svars = vars.get(sec.getName());
            if (svars != null && !svars.isEmpty()) continue;
            it.remove();
        }
        return Collections.unmodifiableList(nonEmpty);
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public List<Section> getNonEmptySections() {
        return this.nonEmptySections;
    }

    public Collection<String> getIdentifiers() {
        return this.identifiers;
    }

    public List<String> getModelNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Section section : this.sections) {
            if (section.type != SectionType.MODEL) continue;
            names.add(section.getName());
        }
        return names;
    }

    public List<String> getIdentifiersOfSection(String section) {
        return this.sectionIdentifiers.get(section);
    }

    public String getSectionOfIdentifier(String identifier) {
        return this.sectionOfIdentifier.get(identifier);
    }

    public Collection<String> getEventNames() {
        return this.eventNames;
    }

    public Collection<String> getAllSectionsOfIdentifier(String identifier) {
        return this.allSectionsOfIdentifier.get(identifier);
    }

    public TypedIdentifier getTypeOfIdentifier(String name) {
        return this.types.get(name);
    }

    public static class Section {
        private final SectionType type;
        private final String name;

        public Section(SectionType type, String name) {
            this.type = type;
            this.name = name;
        }

        public SectionType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum SectionType {
        CONTEXT,
        MODEL;

    }
}

