/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects;

import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.HistoryItem;
import de.prob.core.domainobjects.HistoryListener;
import de.prob.core.domainobjects.State;
import java.util.HashMap;
import java.util.Map;

public class HistoryBasedCache<T>
implements HistoryListener {
    private final Map<State, Integer> stateCounter = new HashMap<State, Integer>();
    private final Map<State, T> store = new HashMap<State, T>();

    public HistoryBasedCache(History history) {
        HistoryItem[] items;
        HistoryItem[] historyItemArray = items = history.getAllItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            HistoryItem item = historyItemArray[n2];
            this.stateEntersHistory(item.getState(), 0);
            ++n2;
        }
    }

    @Override
    public void stateEntersHistory(State state, int position) {
        Integer counter = this.stateCounter.get(state);
        this.stateCounter.put(state, counter == null ? 1 : counter + 1);
    }

    @Override
    public void stateLeavesHistory(State state, int position) {
        Integer counter = this.stateCounter.get(state);
        if (counter != null) {
            if (counter == 1) {
                this.stateCounter.remove(state);
                this.store.remove(state);
            } else {
                this.stateCounter.put(state, counter - 1);
            }
        }
    }

    public void put(State state, T info) {
        if (this.stateCounter.containsKey(state)) {
            this.store.put(state, info);
        }
    }

    public T get(State state) {
        return this.store.get(state);
    }

    public void clear() {
        this.store.clear();
    }
}

