/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.domainobjects;

import de.prob.core.Animator;
import de.prob.core.IComputationListener;
import de.prob.core.command.SetStateCommand;
import de.prob.core.domainobjects.HistoryItem;
import de.prob.core.domainobjects.HistoryListener;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class History
implements Iterable<HistoryItem>,
IComputationListener {
    private static final HistoryItem[] EMPTY_ITEM_ARRAY = new HistoryItem[0];
    private final List<HistoryItem> items = new LinkedList<HistoryItem>();
    private int currentPosition = 0;
    private final Collection<HistoryListener> listeners = new ArrayList<HistoryListener>();

    @Override
    public synchronized Iterator<HistoryItem> iterator() {
        return Collections.unmodifiableList(this.items).iterator();
    }

    public synchronized void add(State s, Operation o) {
        if (this.items.isEmpty()) {
            this.items.add(new HistoryItem(s, null));
            this.currentPosition = 0;
            this.notifyAboutNewState(s, 0);
        } else {
            HistoryItem oldItem = this.items.get(this.currentPosition);
            HistoryItem newItem = new HistoryItem(oldItem.getState(), o);
            int i = this.currentPosition + 1;
            while (i < this.items.size()) {
                this.notifyAboutRemoval(this.items.get(i).getState(), i);
                ++i;
            }
            while (this.items.size() > this.currentPosition) {
                this.items.remove(this.currentPosition);
            }
            this.items.add(newItem);
            HistoryItem historyItem = new HistoryItem(s, null);
            this.items.add(historyItem);
            ++this.currentPosition;
            this.notifyAboutNewState(s, this.currentPosition);
        }
    }

    private void notifyAboutNewState(State state, int position) {
        for (HistoryListener l : this.listeners) {
            l.stateEntersHistory(state, position);
        }
    }

    private void notifyAboutRemoval(State state, int position) {
        for (HistoryListener l : this.listeners) {
            l.stateLeavesHistory(state, position);
        }
    }

    public synchronized int size() {
        return this.items.size();
    }

    public synchronized boolean isEmpty() {
        return this.items.isEmpty();
    }

    public synchronized void gotoPos(int pos) throws ProBException {
        Assert.isTrue((!this.isEmpty() ? 1 : 0) != 0, (String)"History is empty");
        Assert.isTrue((pos >= 0 ? 1 : 0) != 0, (String)("Position must be greater or equal 0, was " + pos));
        Assert.isTrue((pos < this.size() ? 1 : 0) != 0, (String)"Position must be less than history size");
        this.currentPosition = pos;
        SetStateCommand.setState(Animator.getAnimator(), this.getCurrent().getStateId());
        Animator.getAnimator().announceCurrentStateChanged(this.getCurrent().getState(), Operation.NULL_OPERATION);
    }

    public synchronized HistoryItem getCurrent() {
        return this.getHistoryItem(0);
    }

    public synchronized HistoryItem getHistoryItem(int pos) {
        if ((pos = this.currentPosition + pos) >= 0 && pos < this.items.size()) {
            return this.items.get(pos);
        }
        return null;
    }

    public synchronized State getState(int pos) {
        HistoryItem item = this.getHistoryItem(pos);
        return item == null ? null : item.getState();
    }

    public synchronized void gotoNext() {
        if (this.currentPosition < this.items.size() - 1) {
            ++this.currentPosition;
            this.announceCurrentState();
        }
    }

    public synchronized void gotoPrevious() {
        if (this.currentPosition > 0) {
            --this.currentPosition;
            this.announceCurrentState();
        }
    }

    private void announceCurrentState() {
        HistoryItem item = this.getCurrent();
        Animator.getAnimator().announceCurrentStateChanged(item.getState(), Operation.NULL_OPERATION);
    }

    public synchronized void reset() {
        int i = this.items.size() - 1;
        while (i >= 0) {
            this.notifyAboutRemoval(this.items.get(i).getState(), i);
            --i;
        }
        this.items.clear();
        this.currentPosition = 0;
    }

    public synchronized int getCurrentPosition() {
        return this.currentPosition;
    }

    @Override
    public void computedState(State state) {
        if (this.isEmpty()) {
            this.add(state, null);
        }
    }

    public HistoryItem[] getAllItems() {
        return this.items.toArray(EMPTY_ITEM_ARRAY);
    }

    public synchronized void addListener(HistoryListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(HistoryListener listener) {
        this.listeners.remove(listener);
    }
}

