/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.AIntegerPrologTerm;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;

public final class LtlCheckingCommand
implements IComposableCommand {
    private static final String VARIABLE_NAME_ATOMICS = "A";
    private static final String VARIABLE_NAME_STRUCTURE = "S";
    private static final String VARIABLE_NAME_RESULT = "R";
    private final PrologTerm ltlFormula;
    private final int max;
    private final StartMode mode;
    private Result result;

    public LtlCheckingCommand(PrologTerm ltlFormula, int max, StartMode mode) {
        this.ltlFormula = ltlFormula;
        this.max = max;
        this.mode = mode;
    }

    public static Result modelCheck(Animator a, PrologTerm fomula, int max, StartMode mode) throws ProBException {
        LtlCheckingCommand command = new LtlCheckingCommand(fomula, max, mode);
        a.execute(command);
        return command.getResult();
    }

    private Result getResult() {
        return this.result;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        Operation[] initPath;
        int loopEntry;
        PathType pathType;
        ListPrologTerm counterexample;
        CompoundPrologTerm term = (CompoundPrologTerm)bindings.get((Object)VARIABLE_NAME_RESULT);
        Status status = Enum.valueOf(Status.class, term.getFunctor());
        if (term.hasFunctor("counterexample", 3)) {
            counterexample = (ListPrologTerm)term.getArgument(1);
            CompoundPrologTerm loopStatus = (CompoundPrologTerm)term.getArgument(2);
            if (loopStatus.hasFunctor("no_loop", 0)) {
                pathType = PathType.REDUCED;
                loopEntry = -1;
            } else if (loopStatus.hasFunctor("deadlock", 0)) {
                pathType = PathType.FINITE;
                loopEntry = -1;
            } else if (loopStatus.hasFunctor("loop", 1)) {
                pathType = PathType.INFINITE;
                loopEntry = ((AIntegerPrologTerm)loopStatus.getArgument(1)).intValueExact();
            } else {
                throw new CommandException("LTL model check returned unexpected loop status: " + String.valueOf(loopStatus));
            }
            ListPrologTerm operationIds = (ListPrologTerm)term.getArgument(3);
            initPath = new Operation[operationIds.size()];
            int i = 0;
            for (PrologTerm opTerm : operationIds) {
                initPath[i] = Operation.fromPrologTerm(opTerm);
                ++i;
            }
        } else {
            counterexample = null;
            pathType = null;
            loopEntry = -1;
            initPath = null;
        }
        ListPrologTerm atomics = (ListPrologTerm)bindings.get((Object)VARIABLE_NAME_ATOMICS);
        PrologTerm structure = (PrologTerm)bindings.get((Object)VARIABLE_NAME_STRUCTURE);
        boolean noStructure = structure instanceof ListPrologTerm && ((ListPrologTerm)structure).isEmpty();
        this.result = new Result(status, atomics, noStructure ? null : structure, counterexample, pathType, loopEntry, initPath);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("do_ltl_modelcheck");
        this.ltlFormula.toTermOutput(pto);
        pto.printNumber((long)this.max);
        pto.printAtom(this.mode.toString());
        pto.printVariable(VARIABLE_NAME_ATOMICS);
        pto.printVariable(VARIABLE_NAME_STRUCTURE);
        pto.printVariable(VARIABLE_NAME_RESULT);
        pto.closeTerm();
    }

    public static enum PathType {
        INFINITE,
        FINITE,
        REDUCED;

    }

    public static class Result {
        private final Status status;
        private final ListPrologTerm atomics;
        private final PrologTerm structure;
        private final ListPrologTerm counterexample;
        private final PathType pathType;
        private final int loopEntry;
        private final Operation[] initPathOps;

        public Result(Status status, ListPrologTerm atomics, PrologTerm structure, ListPrologTerm counterexample, PathType pathType, int loopEntry, Operation[] initPathOps) {
            this.status = status;
            this.atomics = atomics;
            this.structure = structure;
            this.counterexample = counterexample;
            this.pathType = pathType;
            this.loopEntry = loopEntry;
            this.initPathOps = initPathOps;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isAbort() {
            return this.status.isAbort();
        }

        public ListPrologTerm getAtomics() {
            return this.atomics;
        }

        public PrologTerm getStructure() {
            return this.structure;
        }

        public ListPrologTerm getCounterexample() {
            return this.counterexample;
        }

        public PathType getPathType() {
            return this.pathType;
        }

        public int getLoopEntry() {
            return this.loopEntry;
        }

        public Operation[] getInitPathOps() {
            return this.initPathOps;
        }
    }

    public static enum StartMode {
        init,
        starthere,
        checkhere;

    }

    public static enum Status {
        incomplete(false),
        ok(true),
        counterexample(true),
        nostart(true),
        typeerror(true);

        private final boolean abort;

        private Status(boolean abort) {
            this.abort = abort;
        }

        public boolean isAbort() {
            return this.abort;
        }
    }
}

