/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.parser.ResultParserException;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import java.util.List;

public class GetTimeoutedOperationsCommand
implements IComposableCommand {
    private static final String TIMEOUT_VARIABLE = "TO";
    private final String state;
    private List<String> timeouts;

    public GetTimeoutedOperationsCommand(String state) {
        this.state = state;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        try {
            this.timeouts = PrologTerm.atomicStrings((Iterable)BindingGenerator.getList(bindings, (String)TIMEOUT_VARIABLE));
        }
        catch (ResultParserException e) {
            CommandException commandException = new CommandException(e.getLocalizedMessage(), e);
            commandException.notifyUserOnce();
            throw commandException;
        }
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("op_timeout_occurred").printAtomOrNumber(this.state).printVariable(TIMEOUT_VARIABLE).closeTerm();
    }

    public List<String> getTimeouts() {
        return this.timeouts;
    }
}

