/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.ProblemHandler;
import de.prob.core.command.ExecuteOperationCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import java.util.List;
import java.util.Random;

public class ExecuteRandomStepsCommand {
    private static final Random random = new Random();

    public static void executeOperation(Animator animator, int count) throws ProBException {
        if (count < 1) {
            ProblemHandler.raiseCommandException("Count for Random Animation must be greater than zero");
        }
        Operation operation = null;
        int i = 0;
        while (i < count) {
            State currentState = animator.getCurrentState();
            List<Operation> ops = currentState.getEnabledOperations();
            if (ops.isEmpty()) break;
            operation = ops.get(random.nextInt(ops.size()));
            ExecuteOperationCommand.executeOperation(animator, operation, true);
            if (animator.getCurrentState().isInvariantViolated()) break;
            ++i;
        }
        if (operation != null) {
            animator.announceCurrentStateChanged(animator.getCurrentState(), operation);
        }
    }
}

