/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.EvaluationElement;
import de.prob.core.domainobjects.EvaluationStateElement;
import de.prob.core.domainobjects.History;
import de.prob.core.domainobjects.HistoryBasedCache;
import de.prob.core.domainobjects.State;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.unicode.UnicodeTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EvaluationGetValuesCommand
implements IComposableCommand {
    private static final String COMMAND_NAME = "evaluation_get_values";
    private static final String VALUE_VARNAME = "Values";
    private static final String TRUE = UnicodeTranslator.toUnicode((String)"true");
    private static final String FALSE = UnicodeTranslator.toUnicode((String)"false");
    private static final String CACHE_KEY = EvaluationGetValuesCommand.class.getName() + ".valuecache";
    private final String stateId;
    private final Collection<EvaluationElement> elements;
    private Map<EvaluationElement, EvaluationResult> result;

    public static Collection<EvaluationStateElement> getValuesForExpressionsUncached(State state, Collection<EvaluationElement> elements) throws ProBException {
        List<EvaluationStateElement> result;
        if (state == null || elements.isEmpty()) {
            result = Collections.emptyList();
        } else {
            EvaluationGetValuesCommand cmd = new EvaluationGetValuesCommand(state.getId(), elements);
            Animator.getAnimator().execute(cmd);
            Map<EvaluationElement, EvaluationResult> values = cmd.getResult();
            result = new ArrayList<EvaluationStateElement>(values.size());
            for (Map.Entry<EvaluationElement, EvaluationResult> entry : values.entrySet()) {
                result.add(new EvaluationStateElement(entry.getKey(), state, entry.getValue()));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<EvaluationStateElement> getValuesForExpressionsCached(State state, Collection<EvaluationElement> elements) throws ProBException {
        List<EvaluationStateElement> result;
        if (state == null || elements.isEmpty()) {
            result = Collections.emptyList();
        } else {
            Map<EvaluationElement, EvaluationStateElement> cache;
            Map<EvaluationElement, EvaluationStateElement> map = cache = EvaluationGetValuesCommand.getCache(state);
            synchronized (map) {
                HashSet<EvaluationElement> toCompute = new HashSet<EvaluationElement>(elements);
                Set<EvaluationElement> cached = cache.keySet();
                toCompute.removeAll(cached);
                Collection<EvaluationStateElement> computed = EvaluationGetValuesCommand.getValuesForExpressionsUncached(state, toCompute);
                for (EvaluationStateElement dElement : computed) {
                    cache.put(dElement.getElement(), dElement);
                }
                result = new ArrayList<EvaluationStateElement>(elements.size());
                for (EvaluationElement sElement : elements) {
                    result.add(cache.get(sElement));
                }
                result.addAll(computed);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EvaluationStateElement getSingleValueCached(State state, EvaluationElement element) throws ProBException {
        EvaluationStateElement result;
        if (state == null) {
            result = null;
        } else {
            Map<EvaluationElement, EvaluationStateElement> cache;
            Map<EvaluationElement, EvaluationStateElement> map = cache = EvaluationGetValuesCommand.getCache(state);
            synchronized (map) {
                result = cache.get(element);
                if (result == null) {
                    Collection<EvaluationStateElement> values = EvaluationGetValuesCommand.getValuesForExpressionsUncached(state, Collections.singleton(element));
                    result = values.iterator().next();
                    cache.put(element, result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<EvaluationElement, EvaluationStateElement> getCache(State state) {
        HashMap<EvaluationElement, EvaluationStateElement> cache;
        Animator animator;
        Animator animator2 = animator = Animator.getAnimator();
        synchronized (animator2) {
            HistoryBasedCache<HashMap<EvaluationElement, EvaluationStateElement>> hcache = (HistoryBasedCache<HashMap<EvaluationElement, EvaluationStateElement>>)animator.getData(CACHE_KEY);
            if (hcache == null) {
                History history = animator.getHistory();
                hcache = new HistoryBasedCache<HashMap<EvaluationElement, EvaluationStateElement>>(history);
                history.addListener(hcache);
                animator.setData(CACHE_KEY, hcache);
            }
            if ((cache = (HashMap<EvaluationElement, EvaluationStateElement>)hcache.get(state)) == null) {
                cache = new HashMap<EvaluationElement, EvaluationStateElement>();
                hcache.put(state, cache);
            }
        }
        return cache;
    }

    public EvaluationGetValuesCommand(String stateId, Collection<EvaluationElement> elements) {
        this.stateId = stateId;
        this.elements = new ArrayList<EvaluationElement>(elements);
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        ListPrologTerm valueTerms = (ListPrologTerm)bindings.get((Object)VALUE_VARNAME);
        this.result = EvaluationGetValuesCommand.retrieveValues(this.elements, (Collection<PrologTerm>)valueTerms);
    }

    public Map<EvaluationElement, EvaluationResult> getResult() {
        return this.result;
    }

    private static Map<EvaluationElement, EvaluationResult> retrieveValues(Collection<EvaluationElement> elements, Collection<PrologTerm> valueTerms) {
        if (valueTerms.size() != elements.size()) {
            throw new IllegalStateException("evaluation_get_values returned the wrong number of results");
        }
        HashMap<EvaluationElement, EvaluationResult> results = new HashMap<EvaluationElement, EvaluationResult>();
        Iterator<PrologTerm> it = valueTerms.iterator();
        for (EvaluationElement element : elements) {
            EvaluationResult value;
            String valString;
            CompoundPrologTerm vc;
            PrologTerm valueTerm = it.next();
            if (valueTerm.hasFunctor("p", 1)) {
                vc = (CompoundPrologTerm)valueTerm;
                valString = ((CompoundPrologTerm)vc.getArgument(1)).getFunctor();
                boolean predTrue = "true".equals(valString);
                String asString = predTrue ? TRUE : FALSE;
                value = new EvaluationResult(asString, true, true, predTrue, false);
            } else if (valueTerm.hasFunctor("v", 1)) {
                vc = (CompoundPrologTerm)valueTerm;
                valString = ((CompoundPrologTerm)vc.getArgument(1)).getFunctor();
                String translated = valString.length() == 0 ? "" : UnicodeTranslator.toUnicode((String)valString);
                value = new EvaluationResult(translated, true, false, false, false);
            } else if (valueTerm.hasFunctor("e", 1)) {
                vc = (CompoundPrologTerm)valueTerm;
                String error = ((CompoundPrologTerm)vc.getArgument(1)).getFunctor();
                value = new EvaluationResult(error, true, false, false, true);
            } else if (valueTerm.hasFunctor("i", 0)) {
                value = new EvaluationResult(null, false, false, false, false);
            } else {
                throw new IllegalArgumentException("evaluation_get_values returned unexpected term " + valueTerm.toString());
            }
            results.put(element, value);
        }
        return results;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(COMMAND_NAME);
        pto.openList();
        for (EvaluationElement element : this.elements) {
            element.getId().toTermOutput(pto);
        }
        pto.closeList();
        pto.printAtomOrNumber(this.stateId);
        pto.printVariable(VALUE_VARNAME);
        pto.closeTerm();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EvaluationGetValuesCommand[elements=");
        for (EvaluationElement element : this.elements) {
            sb.append(element.getId());
            sb.append(',');
        }
        sb.append(" stateId=").append(this.stateId).append(']');
        return sb.toString();
    }

    public static class EvaluationResult {
        private final String text;
        private final boolean isActive;
        private final boolean isPredicate;
        private final boolean isPredicateTrue;
        private final boolean hasError;

        public EvaluationResult(String text, boolean isActive, boolean isPredicate, boolean isPredicateTrue, boolean hasError) {
            this.text = text;
            this.isActive = isActive;
            this.isPredicate = isPredicate;
            this.isPredicateTrue = isPredicateTrue;
            this.hasError = hasError;
        }

        public String getText() {
            return this.text;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public boolean isPredicate() {
            return this.isPredicate;
        }

        public boolean isPredicateTrue() {
            return this.isPredicateTrue;
        }

        public boolean hasError() {
            return this.hasError;
        }
    }
}

