/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.EvaluationElement;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.List;

public class EvaluationGetTopLevelCommand
implements IComposableCommand {
    private static final String FIRST_EXPANSION_VARNAME = "FE";
    private final Animator animator;
    private EvaluationElement[] tops;

    public static EvaluationElement[] retrieveTopLevelElements() throws ProBException {
        Animator animator = Animator.getAnimator();
        EvaluationGetTopLevelCommand cmd = new EvaluationGetTopLevelCommand(animator);
        animator.execute(cmd);
        return cmd.getTopLevelElements();
    }

    public EvaluationGetTopLevelCommand(Animator animator) {
        this.animator = animator;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        ListPrologTerm resultList = (ListPrologTerm)bindings.get((Object)FIRST_EXPANSION_VARNAME);
        this.tops = new EvaluationElement[resultList.size()];
        int i = 0;
        for (PrologTerm elemTerm : resultList) {
            this.tops[i] = this.createElement(elemTerm);
            ++i;
        }
    }

    private EvaluationElement createElement(PrologTerm elemTerm) throws CommandException {
        if (!elemTerm.hasFunctor("top", 3)) {
            throw new CommandException("ProB core sent unexpected term " + String.valueOf(elemTerm));
        }
        CompoundPrologTerm elem = (CompoundPrologTerm)elemTerm;
        PrologTerm id = elem.getArgument(1);
        String label = ((CompoundPrologTerm)elem.getArgument(2)).getFunctor();
        ListPrologTerm childrenIds = (ListPrologTerm)elem.getArgument(3);
        EvaluationElement top = new EvaluationElement(this.animator, id, label, (List<PrologTerm>)childrenIds);
        return top;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("evaluation_get_top_level");
        pto.printVariable(FIRST_EXPANSION_VARNAME);
        pto.closeTerm();
    }

    public EvaluationElement[] getTopLevelElements() {
        return this.tops;
    }
}

