/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.List;

public class EvaluationExpandCommand
implements IComposableCommand {
    private static final String LABEL_VARNAME = "Lbl";
    private static final String CHILDREN_VARNAME = "Chs";
    private final PrologTerm evaluationElement;
    private String label;
    private List<PrologTerm> children;

    public EvaluationExpandCommand(PrologTerm evaluationElement) {
        this.evaluationElement = evaluationElement;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        this.label = ((CompoundPrologTerm)bindings.get((Object)LABEL_VARNAME)).getFunctor();
        this.children = (ListPrologTerm)bindings.get((Object)CHILDREN_VARNAME);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm("evaluation_expand_formula");
        this.evaluationElement.toTermOutput(pto);
        pto.printVariable(LABEL_VARNAME);
        pto.printVariable(CHILDREN_VARNAME);
        pto.closeTerm();
    }

    public String getLabel() {
        return this.label;
    }

    public List<PrologTerm> getChildrenIds() {
        return this.children;
    }
}

