/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.eval.AbstractEvalElement;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.Collections;
import java.util.List;

public class EvaluateRawExpressionsCommand
implements IComposableCommand {
    private static final String EVALUATE_TERM_VARIABLE = "Val";
    private final List<AbstractEvalElement> evalElements;
    private final String stateId;
    private List<String> values;

    public EvaluateRawExpressionsCommand(List<AbstractEvalElement> evalElements, String id) {
        this.evalElements = evalElements;
        this.stateId = id;
    }

    public static List<String> evaluate(Animator animator, List<AbstractEvalElement> evalElements, String id) throws ProBException {
        EvaluateRawExpressionsCommand command = new EvaluateRawExpressionsCommand(evalElements, id);
        animator.execute(command);
        return command.getValues();
    }

    public static String evaluate(Animator a, AbstractEvalElement e, String id) throws ProBException {
        return EvaluateRawExpressionsCommand.evaluate(a, Collections.singletonList(e), id).get(0);
    }

    private List<String> getValues() {
        return this.values;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        ListPrologTerm prologTerm = (ListPrologTerm)bindings.get((Object)EVALUATE_TERM_VARIABLE);
        this.values = PrologTerm.atomicStrings((Iterable)prologTerm);
    }

    @Override
    public void writeCommand(IPrologTermOutput pout) {
        pout.openTerm("evaluate_raw_expressions");
        pout.printAtomOrNumber(this.stateId);
        pout.openList();
        for (AbstractEvalElement term : this.evalElements) {
            ASTProlog prolog = new ASTProlog(pout, null);
            term.getPrologAst().apply((Switch)prolog);
        }
        pout.closeList();
        pout.printVariable(EVALUATE_TERM_VARIABLE);
        pout.closeTerm();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EvaluateRawExpression(");
        boolean first = true;
        for (AbstractEvalElement term : this.evalElements) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(term.getLabel());
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }
}

