/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.core.domainobjects.Operation;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ConstraintBasedInvariantCheckCommand
implements IComposableCommand {
    private static final String COMMAND_NAME = "invariant_check";
    private static final String RESULT_VARIABLE = "R";
    private final Collection<String> events;
    private ResultType result;
    private Collection<InvariantCheckCounterExample> counterexamples;

    public ConstraintBasedInvariantCheckCommand(Collection<String> events) {
        this.events = events == null ? null : Collections.unmodifiableCollection(new ArrayList<String>(events));
    }

    public Collection<String> getEvents() {
        return this.events;
    }

    public ResultType getResult() {
        return this.result;
    }

    public Collection<InvariantCheckCounterExample> getCounterExamples() {
        return this.counterexamples;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(COMMAND_NAME);
        if (this.events != null && !this.events.isEmpty()) {
            pto.openTerm("ops");
            pto.openList();
            for (String event : this.events) {
                pto.printAtom(event);
            }
            pto.closeList();
            pto.closeTerm();
        } else {
            pto.printAtom("all");
        }
        pto.printVariable(RESULT_VARIABLE);
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        Collection<InvariantCheckCounterExample> counterexamples;
        ResultType result;
        PrologTerm resultTerm = (PrologTerm)bindings.get((Object)RESULT_VARIABLE);
        if (resultTerm.hasFunctor("interrupted", 0)) {
            result = ResultType.INTERRUPTED;
            counterexamples = null;
        } else if (resultTerm.isList()) {
            ListPrologTerm ceTerm = (ListPrologTerm)resultTerm;
            result = ceTerm.isEmpty() ? ResultType.NO_VIOLATION_FOUND : ResultType.VIOLATION_FOUND;
            counterexamples = Collections.unmodifiableCollection(this.extractExamples(ceTerm));
        } else {
            throw new CommandException("unexpected result from invariant check: " + String.valueOf(resultTerm));
        }
        this.result = result;
        this.counterexamples = counterexamples;
    }

    private Collection<InvariantCheckCounterExample> extractExamples(ListPrologTerm ceTerm) {
        ArrayList<InvariantCheckCounterExample> examples = new ArrayList<InvariantCheckCounterExample>();
        for (PrologTerm t : ceTerm) {
            CompoundPrologTerm term = (CompoundPrologTerm)t;
            String eventName = PrologTerm.atomicString((PrologTerm)term.getArgument(1));
            Operation step1 = Operation.fromPrologTerm((PrologTerm)((CompoundPrologTerm)term.getArgument(2)));
            Operation step2 = Operation.fromPrologTerm((PrologTerm)((CompoundPrologTerm)term.getArgument(3)));
            InvariantCheckCounterExample ce = new InvariantCheckCounterExample(eventName, step1, step2);
            examples.add(ce);
        }
        return examples;
    }

    public static class InvariantCheckCounterExample {
        private final String eventName;
        private final Operation step1;
        private final Operation step2;

        public InvariantCheckCounterExample(String eventName, Operation step1, Operation step2) {
            this.eventName = eventName;
            this.step1 = step1;
            this.step2 = step2;
        }

        public String getEventName() {
            return this.eventName;
        }

        public Operation getStep1() {
            return this.step1;
        }

        public Operation getStep2() {
            return this.step2;
        }
    }

    public static enum ResultType {
        VIOLATION_FOUND,
        NO_VIOLATION_FOUND,
        INTERRUPTED;

    }
}

