/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core.command;

import de.prob.core.Animator;
import de.prob.core.command.CommandException;
import de.prob.core.command.IComposableCommand;
import de.prob.exceptions.ProBException;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.PrologTerm;

public class CheckBooleanPropertyCommand
implements IComposableCommand {
    private static final String PROP_RESULT = "PropResult";
    private static final PrologTerm PROLOG_TRUE = new CompoundPrologTerm("true");
    private static final PrologTerm PROLOG_FALSE = new CompoundPrologTerm("false");
    private final String stateId;
    private final String propertyName;
    private Boolean result;

    protected CheckBooleanPropertyCommand(String propertyName, String stateId) {
        this.propertyName = propertyName;
        this.stateId = stateId;
    }

    public static boolean isPropertyTrue(Animator a, String propertyName, String stateId) throws ProBException {
        CheckBooleanPropertyCommand checkPropertyCommand = new CheckBooleanPropertyCommand(propertyName, stateId);
        a.execute(checkPropertyCommand);
        return checkPropertyCommand.getResult();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) throws CommandException {
        PrologTerm answer = (PrologTerm)bindings.get((Object)PROP_RESULT);
        if (PROLOG_TRUE.equals(answer)) {
            this.result = true;
        } else if (PROLOG_FALSE.equals(answer)) {
            this.result = false;
        } else {
            this.result = null;
            throw new CommandException("Expected true or false, but was: " + String.valueOf(answer));
        }
    }

    private static void writeCommand(IPrologTermOutput pto, String propertyName, String stateId) {
        pto.openTerm("state_property");
        pto.printAtom(propertyName);
        pto.printAtomOrNumber(stateId);
        pto.printVariable(PROP_RESULT);
        pto.closeTerm();
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        CheckBooleanPropertyCommand.writeCommand(pto, this.propertyName, this.stateId);
    }

    public boolean getResult() {
        if (this.result == null) {
            throw new IllegalStateException("Cannot get result before finishing query");
        }
        return this.result;
    }
}

