/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core;

import de.prob.core.Animator;
import de.prob.core.command.IComposableCommand;
import de.prob.core.internal.Activator;
import de.prob.exceptions.ProBException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProBCommandJob
extends Job {
    private final Animator animator;
    private final IComposableCommand command;
    private boolean commandFailed = false;

    public ProBCommandJob(String name, Animator animator, IComposableCommand command) {
        super(name);
        this.animator = animator;
        this.command = command;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Activator.getDefault().registerJob(this);
        monitor.beginTask(this.getName(), -1);
        this.commandFailed = false;
        try {
            this.animator.execute(this.command);
        }
        catch (ProBException e) {
            this.commandFailed = true;
            e.notifyUserOnce();
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected void canceling() {
        this.animator.sendUserInterruptSignal();
    }

    public IComposableCommand getCommand() {
        return this.command;
    }

    public Animator getAnimator() {
        return this.animator;
    }

    public boolean isCommandFailed() {
        return this.commandFailed;
    }
}

