/*
 * Decompiled with CFR 0.152.
 */
package de.prob.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

public class LimitedLogger {
    private static final LogEntry[] EMPTY_ARRAY = new LogEntry[0];
    private static final LimitedLogger LOGGER = new LimitedLogger();
    private static final long DELAY = 300L;
    private final Object newEventsNotification = new Object();
    private int limit = 200;
    private long currentId = 0L;
    private final LinkedList<LogEntry> entries = new LinkedList();
    private final Collection<LogListener> listener = new HashSet<LogListener>();
    private NotificationThread notificationThread = null;
    private Long firstTime;

    public synchronized void log(String category, Object shortDescription, Object longDescription) {
        long now = System.currentTimeMillis();
        LogEntry entry = new LogEntry(this.currentId, now, category, shortDescription, longDescription);
        this.log(now, entry);
    }

    public synchronized void log(String category, String shortDescription, String longDescription) {
        long now = System.currentTimeMillis();
        LogEntry entry = new LogEntry(this.currentId, now, category, shortDescription, longDescription);
        this.log(now, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(long now, LogEntry entry) {
        if (this.entries.size() >= this.limit) {
            this.entries.removeFirst();
        }
        if (this.firstTime == null) {
            this.firstTime = now;
        }
        this.entries.addLast(entry);
        ++this.currentId;
        Object object = this.newEventsNotification;
        synchronized (object) {
            this.newEventsNotification.notifyAll();
        }
    }

    public synchronized void setLimit(int limit) {
        this.limit = limit;
        while (this.entries.size() > limit) {
            this.entries.removeFirst();
        }
    }

    public synchronized LogEntry[] getEntries() {
        return this.entries.toArray(EMPTY_ARRAY);
    }

    public static LimitedLogger getLogger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(LogListener listener) {
        LogListener logListener = listener;
        synchronized (logListener) {
            this.listener.add(listener);
            if (this.notificationThread == null) {
                this.notificationThread = new NotificationThread(this);
                this.notificationThread.setDaemon(true);
                this.notificationThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(LogListener listener) {
        LogListener logListener = listener;
        synchronized (logListener) {
            this.listener.remove(listener);
            if (this.listener.isEmpty()) {
                this.notificationThread.stopNotification();
                this.notificationThread = null;
            }
        }
    }

    public synchronized Long getFirstLoggingTime() {
        return this.firstTime;
    }

    public synchronized void clear() {
        this.entries.clear();
    }

    public static final class LogEntry {
        private final long id;
        private final long time;
        private final String category;
        private final Object shortDescriptionObj;
        private final Object longDescriptionObj;
        private String shortDescription;
        private String longDescription;

        public LogEntry(long id, long time, String category, String shortDescription, String longDescription) {
            this.id = id;
            this.time = time;
            this.category = category;
            this.shortDescription = shortDescription;
            this.longDescription = longDescription;
            this.shortDescriptionObj = null;
            this.longDescriptionObj = null;
        }

        public LogEntry(long id, long time, String category, Object shortDescription, Object longDescription) {
            this.id = id;
            this.time = time;
            this.category = category;
            this.shortDescriptionObj = shortDescription;
            this.longDescriptionObj = longDescription;
        }

        public long getId() {
            return this.id;
        }

        public long getTime() {
            return this.time;
        }

        public String getCategory() {
            return this.category;
        }

        public String getShortDescription() {
            if (this.shortDescription == null && this.shortDescriptionObj != null) {
                this.shortDescription = this.shortDescriptionObj.toString();
            }
            return this.shortDescription;
        }

        public String getLongDescription() {
            if (this.longDescription == null && this.longDescriptionObj != null) {
                this.longDescription = this.longDescriptionObj.toString();
            }
            return this.longDescription;
        }
    }

    public static interface LogListener {
        public void newLoggingInfo();
    }

    private static class NotificationThread
    extends Thread {
        private final LimitedLogger logger;
        private static final long lastNotification = 0L;
        private boolean stopped = false;

        public NotificationThread(LimitedLogger logger) {
            super("LimitedLoggerNotification");
            this.logger = logger;
        }

        public void stopNotification() {
            this.stopped = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    Object object = this.logger.newEventsNotification;
                    synchronized (object) {
                        if (!this.stopped) {
                            this.logger.newEventsNotification.wait();
                        }
                    }
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
                this.notifyIfNewData();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyIfNewData() {
            long current;
            Object object = this.logger;
            synchronized (object) {
                current = this.logger.currentId;
            }
            if (0L < current) {
                object = this.logger.listener;
                synchronized (object) {
                    if (!this.stopped) {
                        for (LogListener l : this.logger.listener) {
                            l.newLoggingInfo();
                        }
                    }
                }
            }
        }
    }
}

